<?php
/* ==================================================
 *   Ktai Login Page
   ================================================== */

if (defined('ABSPATH')) {
	require_once ABSPATH . 'wp-config.php';
} else {
	require_once dirname(dirname(dirname(dirname(__FILE__)))) . '/wp-config.php';
}
nocache_headers();

if (! isset($Ktai_Style) || ! $Ktai_Style->is_mobile()) {
	wp_redirect(get_bloginfo('wpurl') . '/wp-login.php');
	exit();
}
if (file_exists(dirname(__FILE__) . '/admin')) {
	require_once dirname(__FILE__) . '/admin/class.php';
	$KS_Login = new Ktai_Style_Login();
}
exit();

/* ==================================================
 *   Ktai_Style_Login class
   ================================================== */

class Ktai_Style_Login {
	private $parent;
	private $admin;

// ==================================================
public function __construct() {
	global $Ktai_Style;
	$this->parent = $Ktai_Style;
	$this->admin = new Ktai_Style_Admin;
	switch ($_REQUEST['action']) {
	case 'logout':
		$this->logout();
		break;
	default:
		$this->login();
		break;
	}
}

// ==================================================
private function logout() {
	$sid = $this->admin->get_sid();
	$this->admin->unset_session($sid);
	$this->admin->unset_prev_session($sid);
	do_action('wp_logout');
	$redirect_to = 'login.php?loggedout=true';
	if (isset($_POST['redirect_to']) || isset($_GET['redirect_to'])) {
		$redirect_to = isset($_POST['redirect_to']) ? $_POST['redirect_to'] : $_GET['redirect_to'];
		$redirect_to = $this->admin->shrink_redirect_to($redirect_to);
	}
	$this->admin->safe_redirect($redirect_to);
}

// ==================================================
private function login() {
	global $error;
	$errors = array();
	if ((! isset($_POST['redirect_to']) || empty($_POST['redirect_to'])) && ! isset($_GET['redirect_to'])) {
		$redirect_to = 'admin/';
	} else {
		$redirect_to = isset($_POST['redirect_to']) ? $_POST['redirect_to'] : $_GET['redirect_to'];
		$redirect_to = $this->admin->shrink_redirect_to($redirect_to);
	}
	if ($_POST) {
		$user_login = sanitize_user($_POST['log']);
		$user_pass  = $_POST['pwd'];
	} else {
		$user_login = '';
		$user_pass  = '';
	}
	do_action_ref_array('wp_authenticate', array(&$user_login, &$user_pass));
	if ($user_login && $user_pass) {
		$user = new WP_User(0, $user_login);
		if (! $user->has_cap('edit_posts') && (empty($redirect_to) || $redirect_to == 'admin/')) {
			$redirect_to = 'admin/profile.php';
		}
		if (wp_login($user_login, $user_pass, FALSE)) {
			if ($this->admin->set_session($user_login)) {
				do_action('wp_login', $user_login);
				$this->admin->safe_redirect($redirect_to);
				exit();
			} else {
				$errors['session'] = __('<strong>ERROR</strong>: Cannot create a login session.', 'ktai_style');
			}
		}
	}
	if ($_POST && empty($user_login)) {
		$errors['user_login'] = __('<strong>ERROR</strong>: The username field is empty.');
	}
	if ($_POST && empty($user_pass)) {
		$errors['user_pass'] = __('<strong>ERROR</strong>: The password field is empty.');
	}
	if (TRUE == $_GET['loggedout']) {
		$errors['loggedout'] = __('Successfully logged you out.');
	}
	if ($error) {
		$errors['error'] = $error;
	}
	if (preg_match('!^admin/$!', $redirect_to)) {
		$redirect_to = '';
	}

	$charset      = $this->parent->get('charset');
	$iana_charset = $this->parent->get('iana_charset');
	switch ($this->parent->is_mobile()) {
	case 'DoCoMo':
		$logo_ext = 'gif';
		$wrap_start = '';
		$wrap_end = '';
		$style_input = '';
		break;
	case 'Unknown':
		$logo_ext = 'png';
		$style_body = ' style="text-align:center;"';
		$wrap_start = '<div style="width:19em;margin:0 auto;text-align:left;">';
		$wrap_end = '</div>';
		$style_input = 'style="width:100%" ';
		break;
	default:
		$logo_ext = 'png';
		$wrap_start = '';
		$wrap_end = '';
		$style_input = '';
		break;
	}
	ob_start();
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML Basic 1.0//EN" "http://www.w3.org/TR/xhtml-basic/xhtml-basic10.dtd">
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo $iana_charset; ?>" />
<title><?php bloginfo('name'); ?> &rsaquo; <?php _e('Login'); ?></title>
</head><body bgcolor="#006699" text="white" link="#ff99cc" vlink="#ff99cc"<?php echo $style_body; ?>><?php echo $wrap_start; ?>
<center><h1><img src="admin/wplogo-login.<?php echo $logo_ext; ?>" alt="WordPress"/></h1></center>
<?php if ($errors) { echo '<p><font color="#ff99cc">' . apply_filters('login_errors', implode('<br />', $errors)) . "</font></p>\n"; } ?>
<form method="post" action="login.php"><div>
<?php _e('Username:') ?><br /><input type="text" name="log" size="20" istyle="3" mode="alphabet" value="<?php echo attribute_escape(stripslashes($user_login)); ?>" <?php echo $style_input; ?>/><br />
<?php _e('Password:') ?><br /><input type="password" name="pwd" size="20" istyle="3" mode="alphabet" value="" <?php echo $style_input; ?>/></div>
<?php // do_action('login_form'); ?>
<p><input type="submit" name="wp-submit" value="<?php _e('Login'); ?>" /><input type="hidden" name="redirect_to" value="<?php echo attribute_escape($redirect_to); ?>" /></p>
</form>
<div><img localsrc="64" alt="<?php _e('&lt;-', 'ktai_style'); ?>" /><a href="<?php bloginfo('url'); ?>/"><?php printf(__('Back to %s'), get_bloginfo('title', 'display')); ?></a></div>
<?php echo $wrap_end; ?></body></html>
<?php
	$buffer = ob_get_contents();
	ob_end_clean();
	$buffer = mb_convert_encoding($buffer, $charset, get_bloginfo('charset'));
	$buffer = $this->parent->ktai->convert_char($buffer);
	$buffer = $this->parent->ktai->shrink_pre_split($buffer);
	$buffer = $this->parent->ktai->shrink_post_split($buffer);
	header ("Content-Type: text/html; charset=$iana_charset");
	echo $buffer;
}

// ===== End of class ====================
}
?>