<?php
/* ==================================================
 *   Ktai Admin Bulk Edit Comments
 *   based on wp-admin/edit-comments.php of WP 2.3
   ================================================== */

define ('KS_COMMENT_EXCERPT_SIZE', 300);
require_once dirname(__FILE__) . '/admin.php';
$Page = new KS_Admin_Bulk_Comment;
$title = __('Edit Comments');
$parent_file = 'edit-comments.php';
include dirname(__FILE__) . '/admin-header.php';
?>
<h2><?php _e('Comments'); ?></h2>
<form name="searchform" action="" method="get">
<input type="hidden" name="<?php echo KS_SESSION_NAME; ?>" value="<?php $KS_Admin->the_sid() ?>" />
<input type="text" name="ks" value="<?php if (isset($_GET['s'])) { echo attribute_escape($_GET['s']); } ?>" size="20" /> 
<input type="submit" name="Submit" value="<?php _e('Search') ?>"  />  
</form>
<?php
	if (! empty($_POST['delete_comments'])) {
		$Page->show_result();
	}
	
	$per = intval(($Ktai_Style->get('page_size') - 2680) / (KS_COMMENT_EXCERPT_SIZE + 280));
	if ($per < 1) {
		$per = 3;
	} elseif ($per > 20) {
		$per = 20;
	}
	$page_num = isset($_GET['apage']) ? abs((int) $_GET['apage']) : 1;
	$start = $offset = ( $page_num - 1 ) * $per;
	list($comments, $total) = _wp_get_comment_list( isset($_GET['s']) ? $_GET['s'] : false, $start, $per);
	$page_links = paginate_links( array(
		'base' => add_query_arg( 'apage', '%#%' ), 
		'format' => '',
		'total' => ceil($total / $per),
		'current' => $page_num,
		'prev_text' => '<img localsrc="7" alt="&laquo;" />' . __('Previous Page'),
		'next_text' => __('Next Page') . '<img localsrc="8" alt="&raquo;" />'
	));
	
	if ( $page_links ) {
		$page_links = $Ktai_Style->filter_tags($page_links);
		$page_links = str_replace("\n", ' ', $page_links);
		$page_links = str_replace(ks_admin_url(FALSE), '', $page_links);
		echo "<p>$page_links</p>";
	}
	if ($comments) { ?>
<form name="deletecomments" action="" method="post"><?php wp_nonce_field('bulk-comments'); ?>
<dl>
<?php
	$editable = 0;
	foreach ($comments as $comment) {
		$authordata = get_userdata($wpdb->get_var("SELECT post_author FROM $wpdb->posts WHERE ID = $comment->comment_post_ID"));
		$comment_status = wp_get_comment_status($comment->comment_ID); ?>
<dt>
<?php	if ( current_user_can('edit_post', $comment->comment_post_ID) ) {
			$editable++; ?>
<input type="checkbox" name="delete_comments[]" value="<?php echo $comment->comment_ID; ?>" />
<?php	} ?>
<img localsrc="<?php comment_type(68, 112, 112); ?>" alt="[<?php comment_type(__('Comment'), __('Trackback'), __('Pingback')); ?>] " /><?php comment_author(); ?><img localsrc="46" alt=" @ " /><font color="<?php echo ks_option('ks_date_color'); ?>"><?php ks_comment_datetime(); ?></font></dt><dd><?php 
		if ($comment->comment_author_email) { 
		?><img localsrc="108" alt="" /><font color="olive"><?php comment_author_email(); ?></font><br /><?php
		}
		if ($comment->comment_author_url && 'http://' != $comment->comment_author_url) {
		?><img localsrc="112" alt="" /><font color="olive"><?php comment_author_url(); ?></font><br /><?php 
		}
		echo mb_strcut(get_comment_excerpt(), 0, KS_COMMENT_EXCERPT_SIZE);
?>
</dd>
<?php
	} // end foreach
?></dl>
<?php if ($editable) { ?>
<p><input type="submit" name="delete_button" value="<?php _e('Delete Checked Comments &raquo;') ?>" />
<input type="submit" name="spam_button" value="<?php _e('Mark Checked Comments as Spam &raquo;') ?>" /></p>
<?php } ?>
</form>
<?php
	} else {
?>
<p><?php _e('No results found.') ?></p>
<?php
} // end if ($comments)
include dirname(__FILE__) . '/admin-footer.php';
exit();

/* ==================================================
 *   KS_Admin_Bulk_Comment class
   ================================================== */

class KS_Admin_Bulk_Comment {

// ==================================================
public function show_result() {
	global $wpdb;
	check_admin_referer('bulk-comments');
	$i = 0;
	foreach ($_POST['delete_comments'] as $comment) : // Check the permissions on each
		$comment = (int) $comment;
		$post_id = (int) $wpdb->get_var("SELECT comment_post_ID FROM $wpdb->comments WHERE comment_ID = $comment");
		if (current_user_can('edit_post', $post_id)) {
			if (! empty($_POST['spam_button'])) {
				wp_set_comment_status($comment, 'spam');
			} else {
				wp_set_comment_status($comment, 'delete');
			}
			++$i;
		}
	endforeach;
	echo '<p><font color="blue">';
	if (! empty( $_POST['spam_button'])) {
		printf(__ngettext('%s comment marked as spam', '%s comments marked as spam.', $i), $i);
	} else {
		printf(__ngettext('%s comment deleted.', '%s comments deleted.', $i), $i);
	}
	echo '</font></p>';
}

// ===== End of class ====================
}
?>