<?php
/* ͕h~̂߂̓{ꕶłB
   ̃\[Xt@C Shift_JIS ŕۑĂ܂B
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with Shift_JIS. */

/* ==================================================
 *   Ktai_Service_EZweb class
   ================================================== */

class Ktai_Service_EZweb extends Ktai_Services {
	// http://www.au.kddi.com/ezfactory/tec/spec/4_4.html
	static public $devID_to_name = array(
		"KC3B" => "W53K", 
		"ST33" => "INFOBAR 2", 
		"KC3E" => "W44K II (Camera Less)", 
		"SN3B" => "W53S", 
		"CA39" => "W53CA", 
		"ST32" => "W53SA", 
		"TS3E" => "W54T", 
		"SH33" => "W52SH", 
		"CA38" => "W52CA", 
		"MA32" => "W52P", 
		"SN3A" => "W52S", 
		"TS3D" => "W53T", 
		"SA3A" => "W52SA", 
		"HI3A" => "W52H", 
		"KC3A" => "MEDIA SKIN", 
		"SH32" => "W51SH", 
		"SN39" => "W51S", 
		"TS3C" => "W52T", 
		"TS3B" => "W51T", 
		"SA39" => "W51SA", 
		"HI39" => "W51H", 
		"CA37" => "W51CA", 
		"MA31" => "W51P", 
		"KC39" => "W51K", 
		"TS39" => "DRAPE", 
		"TS3A" => "W47T", 
		"SN38" => "W44S", 
		"KC38" => "W44K/K II", 
		"SA38" => "W43SA", 
		"TS38" => "W45T", 
		"CA35" => "W43CA", 
		"HI38" => "W43H/H II", 
		"SN37" => "W43S", 
		"KC37" => "W43K", 
		"ST31" => "W42SA", 
		"SH31" => "W41SH", 
		"CA34" => "W42CA", 
		"HI37" => "W42H", 
		"TS37" => "W44T/T II/T III", 
		"TS35" => "neon", 
		"TS36" => "W43T", 
		"SN36" => "W42S", 
		"KC36" => "W42K", 
		"KC35" => "W41K", 
		"SA36" => "W41SA", 
		"TS34" => "W41T", 
		"HI36" => "W41H", 
		"CA33" => "W41CA", 
		"SN34" => "W41S", 
		"HI34" => "PENCK", 
		"SA35" => "W33SA/SA II", 
		"TS33" => "W32T", 
		"SA34" => "W32SA", 
		"KC34" => "W32K", 
		"HI35" => "W32H", 
		"SN33" => "W32S", 
		"SN35" => "W32S", 
		"CA32" => "W31CA", 
		"TS32" => "W31T", 
		"SN32" => "W31S", 
		"KC33" => "W31K/K II", 
		"SA33" => "W31SA/SA II", 
		"SA32" => "W22SA", 
		"HI33" => "W22H", 
		"CA31" => "W21CA/CA II", 
		"TS31" => "W21T", 
		"SA31" => "W21SA", 
		"SN31" => "W21S", 
		"KC32" => "W21K", 
		"HI32" => "W21H", 
		"KC31" => "W11K", 
		"HI31" => "W11H", 
		"CA36" => "E03CA", 
		"SA37" => "E02SA", 
		"ST2C" => "Sweets cute", 
		"ST29" => "Sweets pure", 
		"CA28" => "G'zOne TYPE-R", 
		"ST26" => "Sweets", 
		"ST25" => "talby", 
		"ST22" => "INFOBAR", 
		"KC2A" => "A5528K", 
		"SA2A" => "A5527SA", 
		"KC29" => "A5526K", 
		"ST2D" => "A5525SA", 
		"TS2D" => "A5523T", 
		"SA29" => "A5522SA", 
		"KC28" => "A5521K", 
		"ST2A" => "A5520SA/SA II", 
		"ST28" => "A5518SA", 
		"TS2C" => "A5517T", 
		"TS2B" => "A5516T", 
		"KC27" => "A5515K", 
		"ST27" => "A5514SA", 
		"CA27" => "A5512CA", 
		"TS2A" => "A5511T", 
		"TS29" => "A5509T", 
		"ST24" => "A5507SA", 
		"TS28" => "A5506T", 
		"SA27" => "A5505SA", 
		"TS27" => "A5504T", 
		"SA26" => "A5503SA", 
		"KC24" => "A5502K", 
		"KC25" => "A5502K", 
		"TS26" => "A5501T", 
		"CA26" => "A5407CA", 
		"CA25" => "A5406CA", 
		"ST23" => "A5405SA", 
		"SN25" => "A5404S", 
		"CA24" => "A5403CA", 
		"SN24" => "A5402S", 
		"CA23" => "A5401CA II", 
		"CA23" => "A5401CA", 
		"ST21" => "A5306ST", 
		"KC22" => "A5305K", 
		"TS24" => "A5304T", 
		"HI24" => "A5303H II", 
		"HI23" => "A5303H", 
		"CA22" => "A5302CA", 
		"TS23" => "A5301T", 
		"SA22" => "A3015SA", 
		"PT22" => "A3015SA", 
		"PT21" => "A1405PT", 
		"SN29" => "A1405PT", 
		"KC26" => "A1403K", 
		"SN27" => "A1403K", 
		"SN28" => "A1402S II (Camera Less)", 
		"SN26" => "A1402S", 
		"KC23" => "A1401K", 
		"SA28" => "A1305SA", 
		"TS25" => "A1304T II", 
		"TS25" => "A1304T II", 
		"TS25" => "A1304T (Camera Less)", 
		"SA25" => "A1303SA", 
		"SA24" => "A1302SA", 
		"SN23" => "A1301S", 
		"ST14" => "A1014ST", 
		"SN21" => "A3014S", 
		"TS22" => "A3013T", 
		"CA21" => "A3012CA", 
		"SA21" => "A3011SA", 
		"SN22" => "A1101S", 
		"KC14" => "A1012K II", 
		"KC14" => "A1012K", 
		"ST13" => "A1011ST", 
		"MA21" => "C3003P", 
		"KC21" => "C3002K", 
		"HI21" => "C3001H", 
		"SN17" => "C1002S", 
		"SY15" => "C1001SA", 
		"CA14" => "C452CA", 
		"HI14" => "C451H", 
		"TS14" => "C415T", 
		"KC13" => "C414K II", 
		"KC13" => "C414K", 
		"SN15" => "C413S", 
		"SN16" => "C413S", 
		"SY14" => "C412SA", 
		"ST12" => "C411ST", 
		"TS13" => "C410T", 
		"CA13" => "C409CA", 
		"MA13" => "C408P", 
		"HI13" => "C407H", 
		"SN13" => "C406S", 
		"SY13" => "C405SA", 
		"SN12" => "C404S", 
		"SN14" => "C404S", 
		"ST11" => "C403ST", 
		"DN11" => "C402DE", 
		"SY12" => "C401SA", 
		"KCTE" => "TK51", 
		"TST9" => "TT51", 
		"KCU1" => "TK41", 
		"SYT5" => "TS41", 
		"KCTD" => "TK40", 
		"TST8" => "TT32", 
		"TST7" => "TT31", 
		"KCTC" => "TK31", 
		"SYT4" => "TS31", 
		"KCTB" => "TK23", 
		"KCTA" => "TK22", 
		"TST6" => "TT22", 
		"KCT9" => "TK21", 
		"TST5" => "TT21", 
		"TST4" => "TT11", 
		"KCT8" => "TK12", 
		"SYT3" => "TS11", 
		"KCT7" => "TK11", 
		"MIT1" => "TD11", 
		"MAT3" => "TP11", 
		"KCT6" => "TK05", 
		"TST3" => "TT03", 
		"KCT5" => "TK04", 
		"KCT4" => "TK03", 
		"SYT2" => "TS02", 
		"MAT1" => "TP01", 
		"MAT2" => "TP01", 
		"TST2" => "TT02", 
		"KCT3" => "TK0K", 
		"KCT2" => "TK02", 
		"KCT1" => "TK01", 
		"TST1" => "TT01", 
		"SYT1" => "TS01", 
		);

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->user_agent = $user_agent;
	$this->operator   = 'KDDI';
	$this->type       = 'EZweb';
	preg_match('!^(KDDI-([A-Za-z0-9]+)|UP\.Browser/\d\.\d+-([A-Za-z0-9]+)) !', $user_agent, $specs);
	$dev_ID = $specs[2] ? $specs[2] : $specs[3];
	if (in_array($dev_ID, array_keys(self::$devID_to_name))) {
		$this->term_name = self::$devID_to_name[$dev_ID];
	} else {
		$this->term_name = "(Unknown au device:$dev_ID)";
	}
	$this->sub_ID     = @$_SERVER['HTTP_X_UP_SUBNO'];
	$this->page_size  = $specs[2] ? 9000 : 7500;
	$this->cache_size = $specs[2] ? 102400 : 49152;
	$this->charset    = 'SJIS-win';
	$this->mime_type  = 'text/html';
	$this->preamble   = '<?xml version="1.0" encoding="__CHARSET__"?>
<!DOCTYPE html PUBLIC "-//OPENWAVE//DTD XHTML 1.0//EN" "http://www.openwave.com/DTD/xhtml-basic.dtd">';
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	$smiles = array(
		'icon_smile.gif'     => '<img localsrc="257">',
		'icon_biggrin.gif'   => '<img localsrc="454">',
		'icon_sad.gif'       => '<img localsrc="441">',
		'icon_surprised.gif' => '<img localsrc="350">',
		'icon_eek.gif'       => '<img localsrc="451">',
		'icon_confused.gif'  => '<img localsrc="444">',
		'icon_cool.gif'      => '<img localsrc="382">',
		'icon_mad.gif'       => '<img localsrc="258">',
		'icon_razz.gif'      => '<img localsrc="264">',
		'icon_neutral.gif'   => '<img localsrc="440">',
		'icon_wink.gif'      => '<img localsrc="348">',
		'icon_lol.gif'       => '<img localsrc="789">',
		'icon_redface.gif'   => '<img localsrc="349">', // 446 is better?
		'icon_cry.gif'       => '<img localsrc="259">',
		'icon_evil.gif'      => '<img localsrc="277">',
		'icon_twisted.gif'   => '<img localsrc="277">',
		'icon_rolleyes.gif'  => '<img localsrc="442">',
		'icon_exclaim.gif'   => '<img localsrc="2">',
		'icon_question.gif'  => '<img localsrc="3">',
		'icon_idea.gif'      => '<img localsrc="77">',
		'icon_arrow.gif'     => '<img localsrc="63">',
		'icon_mrgreen.gif'   => '<img localsrc="814">',
	);
	return parent::replace_smiley($buffer, $smiles);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function convert_char($buffer) {
	$buffer = preg_replace('!(<img localsrc="[^"\\\\]*?(\\\\.[^"\\\\]*)*")( alt="[^"\\\\]*?(\\\\.[^"\\\\]*)*")? ?/?>!', '$1>', $buffer);
	return $buffer;
}

// ===== End of class ====================
}
?>