<?php
/* 
Plugin Name: Weather Journal
Plugin URI: http://wppluginsj.sourceforge.jp/weather_journal/
Description: Insert a weather symbol at each date.
Author: IKEDA yuriko
Version: 1.10
Author URI: http://www.yuriko.net/cat/wordpress
*/
/*  Copyright (c) 2007 yuriko

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

$Weather = new YN_Weather;
add_filter('the_date', array($Weather, 'show'), 10, 4);
add_action('dbx_post_sidebar', array($Weather, 'edit'), 10);
add_action('publish_post', array($Weather, 'set'), 10);
add_action('edit_post', array($Weather, 'set'), 10);
if (isset($_GET['activate']) && $_GET['activate'] == 'true') {
	add_action('init', array($Weather, 'install'));
}

/* ==================================================
 *   Weather classses
   ================================================== */

class YN_Weather_Item {
	public $type;
	public $desc;
}

class YN_Weather {
	private $db_prefix;
	private $url;
	static public $type;
	static public $ktai_pict = array(
		'sun'          => '44',
		'cloud'        => '107',
		'thunder'      => '16',
		'fog'          => '305',
		'rain'         => '95',
		'storm'        => '190',
		'snow'         => '191',
		'snowfall'     => '191',
		'sleet'        => '191',
		'snow_thunder' => '191',
	);

// ==================================================
public function __construct() {
	global $wpdb;
	$this->db_prefix = $wpdb->prefix . 'yn';
	// Use the same weather table of Yuriko.Net (Available only at Yuriko.Net)  
	if (file_exists(dirname(dirname(dirname(dirname(dirname(__FILE__))))) . '/T5_Prefs.php')) {
		$this->db_prefix = '';
	}

	$path = preg_replace('/^.*wp-content/', 'wp-content', dirname(__FILE__));
	if (DIRECTORY_SEPARATOR == '\\') {
		$path = str_replace('\\', '/', $path);
	}
	if (! preg_match('/^wp-content/', $path)) {
		$path = 'wp-content/plugins/weather_journal';
	}
	load_plugin_textdomain('weather_journal', $path);
	$this->url = get_bloginfo('wpurl') . "/$path/";

	$this->type = array(
		'sun'                => __('Sunny', 'weather_journal'),
		'sun+cloud'          => __('Sunny intervals', 'weather_journal'), 
		'sun-cloud'          => __('Sunny then Cloudy', 'weather_journal'), 
		'sun+rain'           => __('Sunny, and Shower', 'weather_journal'), 
		'sun.rain'           => __('Sunny, intermittent Shower', 'weather_journal'), 
		'sun-rain'           => __('Sunny then Rain', 'weather_journal'), 
		'sun.thunder'        => __('Sunny, intermittent Thunderstorm', 'weather_journal'), 
		'sun-thunder'        => __('Sunny then Thunderstorm', 'weather_journal'), 
		'sun+snow'           => __('Sunny, and Snow Shower', 'weather_journal'), 
		'sun.snow'           => __('Sunny, intermittent Snow', 'weather_journal'), 
		'sun-snow'           => __('Sunny then Snow', 'weather_journal'), 
		'cloud'              => __('Cloudy', 'weather_journal'), 
		'cloud+sun'          => __('Partly Cloudy', 'weather_journal'), 
		'cloud-sun'          => __('Cloudy then Sunny', 'weather_journal'), 
		'cloud+rain'         => __('Shower', 'weather_journal'), 
		'cloud.rain'         => __('Intermittent Shower', 'weather_journal'), 
		'cloud-rain'         => __('Cloudy then Rain', 'weather_journal'), 
		'cloud+thunder'      => __('Shower with Thunder', 'weather_journal'), 
		'cloud.thunder'      => __('Intermittent Thunderstorm', 'weather_journal'), 
		'cloud-thunder'      => __('Cloudy then Thunderstorm', 'weather_journal'), 
		'cloud+snow'         => __('Snow Shower', 'weather_journal'), 
		'cloud.snow'         => __('Intermittent Snow', 'weather_journal'), 
		'cloud-snow'         => __('Cloudy then Snow', 'weather_journal'), 
		'cloud+snow_thunder' => __('Snow Shower with Thunder', 'weather_journal'), 
		'fog'                => __('Fog', 'weather_journal'), 
		'rain'               => __('Rain', 'weather_journal'), 
		'storm'              => __('Storm', 'weather_journal'), 
		'thunder'            => __('Thunderstorm', 'weather_journal'), 
		'rain+sun'           => __('Rain, Sunny at times', 'weather_journal'), 
		'rain-sun'           => __('Rain then Sunny', 'weather_journal'), 
		'rain+cloud'         => __('Mostly Rain', 'weather_journal'), 
		'rain-cloud'         => __('Rain then Cloudy', 'weather_journal'), 
		'rain.sleet'         => __('Rain, intermittent Sleet', 'weather_journal'), 
		'rain+snow'          => __('Rain with Snow Shower', 'weather_journal'), 
		'rain.snow'          => __('Rain, intermittent Snow', 'weather_journal'), 
		'rain-snow'          => __('Rain then Snow', 'weather_journal'), 
		'snow'               => __('Snow', 'weather_journal'), 
		'snowfall'           => __('Heavy Snow', 'weather_journal'), 
		'snow+sun'           => __('Snow, Sunny at times', 'weather_journal'), 
		'snow-sun'           => __('Snow then Sunny', 'weather_journal'), 
		'snow+cloud'         => __('Mostly Snow', 'weather_journal'), 
		'snow-cloud'         => __('Snow then Cloudy', 'weather_journal'), 
		'snow+rain'          => __('Snow with Rain Shower', 'weather_journal'), 
		'snow.rain'          => __('Snow, intermittent Rain Shower', 'weather_journal'), 
		'snow-rain'          => __('Snow then Rain', 'weather_journal'), 
		'snow.sleet'         => __('Snow, intermittent Sleet', 'weather_journal'), 
		'snow-sleet'         => __('Snow then Sleet', 'weather_journal'), 
		'snow_thunder'       => __('Snow with Thunder', 'weather_journal'), 
	);
	return;
}

// ==================================================
public function show($the_date, $d, $before, $after) {
	if (! $the_date) {
		return $the_date;
	}
	global $post;
	$weather = $this->read($post->post_date);
	if (is_null($weather)) {
		return $the_date;
	}
	if (function_exists('is_ktai') && is_ktai() || function_exists('is_mobile') && is_mobile()) {
		$output = $this->mobile_weather($weather);
		if ($output) {
			$the_date = preg_replace('/' . preg_quote($after, '/') . '$/', __('Weather:', 'weather_journal') . $output . $after, $the_date);
		}
	} else {
		if ($weather->type) {
			$output .= '<img src="' . $this->url . "{$weather->type}.png" . '" alt="' . $weather->desc . '" />';
		}
		$the_date .= "\n" . '<div class="weather">' . $output . '</div>';
	}
	return $the_date;
}

// ==================================================
private function mobile_weather($weather) {
	if (class_exists('Ktai_Style')) {
		global $Ktai_Style;
		if ($Ktai_Style->is_mobile() != 'Unknown') {
			if (strpos($weather->type, '+') !== FALSE || strpos($weather->type, '.') !== FALSE) {
				$w = preg_split('/[+.]/', $weather->type, 2);
				$output = $this->ktai_pict($w[0], $weather->desc) . '/' . $this->ktai_pict($w[1], '');
			} elseif (strpos($weather->type, '-') !== FALSE) {
				$w = explode('-', $weather->type);
				$output = $this->ktai_pict($w[0], $weather->desc) . '<img localsrc="63" alt="" />' . $this->ktai_pict($w[1], '');
			} elseif ($weather->type) {
				$output = $this->ktai_pict($weather->type, $weather->desc);
			} else {
				$output = '';
			}
		} else {
			$output = $weather->desc;
		}
	} else {
		$output = $weather->desc;
	}
	return $output;
}

// ==================================================
private function ktai_pict($type, $desc) {
	return '<img localsrc="' . self::$ktai_pict[$type] . '" alt="' . $desc . '" />';
}

// ==================================================
public function edit() {
	global $post;
	if (isset($post->post_date)) {
		$weather = $this->read($post->post_date);
		$type = $weather->type;
	} else {
		$type = '-';
	}
	$list = array('-' => __('(unknown)', 'weather_journal')) + $this->type;
	$html = '';
	foreach ($list as $k => $w) {
		$selected = ($type == $k) ? '" selected="selected"' : '"';
		$html .= '<option value="' . $k . $selected . '>' . $w . '</option>' . "\n";
	}
?>
<fieldset id="weatherdiv" class="dbx-box">
<h3 class="dbx-handle"><?php _e('Weather of this date', 'weather_journal') ?></h3> 
<div class="dbx-content"><select name="weather_of_date"><?php echo $html; ?></select></div>
</fieldset>
<?php
}

// ==================================================
public function set($post_ID) {
	if (! isset($_POST['weather_of_date'])) {
		return $post_ID;
	}
	$weather = $_POST['weather_of_date'];
	if ($weather == '-' || ! array_key_exists($weather, $this->type)) {
		return $post_ID;
	}
	$post = get_post($post_ID);
	$this->update($post->post_date, $weather);
	return $post_ID;
}

// ==================================================
private function read($date) {
	global $wpdb;
	if (is_array($date)) {
		$date_list = $date;
	} else {
		$date_list = array($date);
	}
	$result = array();
	foreach ($date_list as $pub_date) {
		$d = mysql2date('Y-m-d', $pub_date);
		$type = $wpdb->get_var("SELECT type FROM `{$this->db_prefix}weather` WHERE pub_date = '$d' LIMIT 1");
		$w = new YN_Weather_Item;
		$w->type = $type;
		$w->desc = $type ? $this->type[$type] : '';
		$result[$d] = $w;
	}
	if (is_array($date)) {
		return $result;
	}
	return $result[$d];
}

// ==================================================
private function update($pub_date, $type) {
	global $wpdb;
	$date_sql = mysql2date('Y-m-d', $pub_date);
	$type_sql = $wpdb->escape($type);
	$result = $wpdb->query("REPLACE INTO `{$this->db_prefix}weather` (pub_date, type) VALUES ('$date_sql', '$type_sql')");
	return $result;
}

// ==================================================
public function install() {
	global $wpdb, $user_level;
	get_currentuserinfo();
	if ($user_level < 8) {
		return;
	}
	$types = implode("','", array_keys($this->type));
	$sql = "CREATE TABLE IF NOT EXISTS `{$this->db_prefix}weather` (
		    `pub_date` date NOT NULL default '1900-00-00',
		    `type` enum('$types') default NULL,
		    PRIMARY KEY (`pub_date`)
		    );";
	require_once(ABSPATH . 'wp-admin/upgrade-functions.php');
	dbDelta($sql);
	return;
}

// ===== End of class ==============================
}

?>