<?php
/*
Plugin Name: Recent Comments with Gravatar
Version: 0.2
Plugin URI: http://wppluginsj.sourceforge.jp/wcg/
Description: Recent Comments with Gravatar. Licensed under the terms of the <a href="http://www.opensource.jp/gpl/gpl.ja.html">GPL</a>.
Author: Otsukare
Author URI: http://xn--65q67bs6i.jp/
*/

if(function_exists('load_plugin_textdomain')) {
	load_plugin_textdomain('rc', 'wp-content/plugins/recent_comments/languages');
}

function wpj_recent_comments($g_size = 30, $no_comments = 10, $comment_lenth = 20, $show_pass_post = false) {
        global $wpdb, $tablecomments, $tableposts;

        $request = "SELECT ID, comment_ID, comment_content, comment_author, comment_author_email FROM $tableposts, $tablecomments WHERE $tableposts.ID=$tablecomments.comment_post_ID AND post_status = 'publish' ";

        if(!$show_pass_post) { $request .= "AND post_password ='' "; }

        $request .= "AND comment_approved = '1' ORDER BY $tablecomments.comment_date DESC LIMIT $no_comments";
        $comments = $wpdb->get_results($request);

	echo "<li id=\"recent_comments\"><h2>";
	_e("Recent Comments", "rc");
	echo "</h2>\n";
	echo "<ul>\n";

        foreach ($comments as $comment) {
		$comment_id = $comment->comment_ID;
		$comment_content = strip_tags($comment->comment_content);
		$comment_excerpt = mb_substr($comment_content, 0, $comment_lenth)."...";
		$permalink = get_permalink($comment->ID)."#comment-".$comment->comment_ID;
		$comment_author_email = $comment->comment_author_email;

	echo "<li style=\"clear:both; margin-right:20px; padding-top:3px;\" id=\"comment-".$comment_id."\">";
		if (function_exists('gravatar')) {
			echo gravatar_image($comment_author_email, '', $g_size, $g_size, 'Gravatar', '', '', TRUE);
		} else {
			echo '<img src="' . get_settings('siteurl') . '/wp-content/plugins/recent_comments/images/tick.png" alt="tick" /> ';
		}
			echo "<a href=\"" . $permalink . "\" title=\"View the entire comment\">";
			echo $comment_excerpt;
			echo "</a>";
			echo "</li>\n";
	            }

	echo "<li style=\"clear: both; padding-top:10px;\">";

	if (!function_exists('gravatar')) {
		echo "<a href=\"http://wppluginsj.sourceforge.jp/gravatars2/\"><strong>Download Gravatar2 &raquo;</strong></a>";
	} else {
		echo "<a href=\"http://wppluginsj.sourceforge.jp/wcg/\"><strong>Download RC with G2 &raquo;</strong></a>";
	}

	echo "</li>\n";
	echo "</ul>\n";
	echo "</li>\n";
}
?>