<?php 
/* これは文字化け防止のための日本語文字列です。*/
/* 
Plugin Name: Force Wave Dash
Plugin URI: http://www.yuriko.net/arc/2007/03/01a
Description: In UTF-8 based weblogs, convert full-width-tild characters to wave dash at creating/editing posts and at outputting contents.
Author: IKEDA yuriko
Version: 0.70-alpha
Author URI: http://www.yuriko.net/cat/wordpress
*/

if (get_bloginfo('charset') == 'UTF-8' && function_exists('mb_ereg_replace')) {
	add_action('publish_post', array('Force_Wavedash', 'convert_posts'));
	add_action('save_post', array('Force_Wavedash', 'convert_posts'));
	add_filter('the_content', array('Force_Wavedash', 'tild2wave'));
}

/* ==================================================
 *   Fix_Fullwidth_Tild class
   ================================================== */

class Force_Wavedash {

// ==================================================
function tild2wave($content) {
	$replaced = mb_ereg_replace('～', '〜', $content);
	return ($replaced ? $replaced : $content);
}

// ==================================================
function convert_posts($post_id) {
	$post = get_post($post_id);
	$content = Force_Wavedash::tild2wave($post->post_content);
	global $wpdb;
	$wpdb->query("UPDATE {$wpdb->posts} SET post_content = '" . $wpdb->escape($content) . "' WHERE ID = " . intval($post->ID));
	return $post_id;
}

// ===== End of class ====================
}

?>