<?php
/*
Plugin Name: Lightweight Google Maps
Plugin URI: http://wppluginsj.sourceforge.jp/lightweight-google-maps/
Description: This plugin makes an instant googlemap of posts on your wordpress blog. Based on Plug 'n' Play Google Map plugin by yongfook (http://www.yongfook.com/2005/05/28/plug-n-play-google-map/)
Version: 0.8.0
Author: IKEDA Yuriko
Author URI: http://www.yuriko.net/travel/category/wordpress/
*/

define('LWGM_PLUGIN_PATH','wp-content/plugins/lightweight-google-maps');
load_plugin_textdomain('lw_googlemaps', $path = LWGM_PLUGIN_PATH);

$Lwgm = new Lightweight_Google_Maps;
add_action('admin_menu', array($Lwgm, 'add_admin_page'));
add_action('wp_head',    array($Lwgm, 'output_style'));
add_action('wp_footer',  array($Lwgm, 'output_map'));

// ==================================================
function lwgm_each_map() {
	list($lat, $lon) = Lightweight_Google_Maps::get_LatLon();
	if (! $lat || ! $lon) {
		return;
	}
	$map_type = get_option('lw_each_map_type');
	$map_id   = get_option('yf_google_page_id');
	if ($map_id) {
		$url = get_bloginfo('url') . "/$map_id/?lat=$lat&amp;lon=$lon";
		$link = '<a href="' . $url . '">' . __('View this location on my large map &raquo;', 'lw_googlemaps') . '</a>';
	} else {
		$url = '';
		$link = '';
	}
	if ($map_id && $map_type == 'LWGM_LINK_TO_MAP') {
		echo '<p class="map_link">' . $link . '</p>';
	} else {
		global $post, $Each_Maps;
		$Each_Maps[$post->ID] = array($lat, $lon, $url);
		echo '<div class="each_map" id="map-' . $post->ID . '">' . $link . '</div>' . "\n";
	}
}

// ==================================================
function lwgm_dropdown_cats() {
	global $Lwgm_On;
	if (isset($Lwgm_On)) {
?>
<form action="" method="get"><div>
<label><?php _e('Refine by category:', 'lw_googlemaps');
dropdown_cats(FALSE,'all','name','asc',FALSE,FALSE,TRUE,FALSE,intval($_GET['cat'])); ?>
</label>
<input type="submit" name="mode" value="<?php _e('Show', 'lw_googlemaps'); ?>" />
</div></form>
<?php
	}
}

/* ==================================================
 *   Lightweight_Google_Maps Class
   ================================================== */

class Lightweight_Google_Maps {

// ==================================================
function get_LatLon() {
	global $post;
	list($lat, $lon) = split(',', get_post_meta($post->ID, 'Lat_Long', true));
	return array(floatval($lat), floatval($lon));
}

// ==================================================
function output_style() {
	if (is_page(get_option('yf_google_page_id'))) {
		global $Lwgm_On;
		$Lwgm_On = TRUE;
		$map_width = intval(get_option('yf_google_width'));
		if (! $map_width) {
			$map_width = 400;
		}
		$map_height = intval(get_option('yf_google_height'));
		if (! $map_height) {
			$map_height = 400;
		}
		$element = '#google_maps';
	} elseif (! is_page() && get_option('lw_each_map_type') != 'LWGM_LINK_TO_MAP') {
		$map_width = intval(get_option('lw_each_map_width'));
		if (! $map_width) {
			$map_width = 300;
		}
		$map_height = intval(get_option('lw_each_map_height'));
		if (! $map_height) {
			$map_height = 150;
		}
		$element = '.each_map';
	} else {
		return;
	}
?>
<style type="text/css">
<?php echo $element; ?> {
	width:<?php echo $map_width; ?>px;
	height:<?php echo $map_height; ?>px;
	margin:1em auto;
	border:1px solid #999;
	line-height:1.25em;
	text-align:center;
}
<?php echo $element; ?> img {
	margin:0;
	padding:0;
	border:0 none;
}
<?php echo $element; ?> .infowindow {
	text-align:left;
	font-size:0.88em;
}
<?php echo $element; ?> p {
	margin:0;
	text-indent:0;
	text-align:left;
	font-size:0.75em;
}
</style>
<script src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=<?php echo  get_option('yf_google_api_key');?>" type="text/javascript"></script>
<?php
}

// ==================================================
function output_map() {
	global $Lwgm_On, $Each_Maps;
	if (isset($Lwgm_On)) {
		$this->fixed_map();
	} elseif (count(@$Each_Maps)) {
		$this->each_map($Each_Maps);
	}
}

// ==================================================
function fixed_map() {
	$loc = array();
	if (isset($_GET['lon'])) {
		$lat = floatval($_GET['lat']);
		$lon = floatval($_GET['lon']);
		$zoom = 13;
		$loc = $this->targeted_locations($lat, $lon, $zoom);
	} else {
		if (isset($_GET['cat'])) {
			$loc = $this->categorized_locations(intval($_GET['cat']));
			$zoom = 7;
		} else {
			$loc = $this->recent_locations(get_option('lw_num_recent_markers'));
			$zoom = intval(get_option('yf_zoom_level'));
		}
	}
	if (count($loc) > 0) {
		$lat = $loc[0]['lat'];
		$lon = $loc[0]['lon'];
	} else {
		$lat = "35.36273602350485";
		$lon = "138.73080253601074";
	}
	if (! $zoom) {
		$zoom = 8;
	}
	$map_type = get_option('yf_map_type');
	if (! $map_type) {
		$map_type = 'G_HYBRID_MAP';
	}
?>
<script type="text/javascript">
	//<![CDATA[
	function lwgm_create_marker(lat, lon, title, link, date, excerpt) {
		var marker = new GMarker(new GLatLng(lat, lon));
		var html = "<div class=\"infowindow\"><a href=\""+link+"\"><strong>"+title+"</strong></a><br />"+date+"</div><p>"+excerpt+"</p>";
		GEvent.addListener(marker, "click", function() {
			marker.openInfoWindowHtml(html, {"maxWidth":200});
		});
		return marker;
	}
	onload = function() {
		var map = new GMap2(document.getElementById("google_maps"));
		map.addControl(new GLargeMapControl());
		map.addControl(new GMapTypeControl());
		map.addControl(new GScaleControl());
		map.addControl(new GOverviewMapControl());
		map.setCenter(new GLatLng(<?php echo $lat;?>, <?php echo $lon;?>), <?php echo $zoom;?>, <?php echo $map_type; ?>);
<?php
	if (count($loc) > 0) {
		foreach($loc as $l) {
			echo sprintf('		var marker = lwgm_create_marker(%F,%F,"%s","%s","%s","%s");', 
			floatval($l['lat']), floatval($l['lon']), 
			wp_specialchars($l['title']), wp_specialchars($l['link']), 
			wp_specialchars($l['date']), wp_specialchars($l['excerpt'])
			) . "\nmap.addOverlay(marker);\n"; 
		}
	}
?>
	}
	onunload = GUnload;
	//]]>
	</script>
<?php
}

// ==================================================
function targeted_locations($center_lat, $center_lon, $zoom) {
	$loc[0] = array();
	$range_w = 0.06; // ad-hoc value
	$range_h = 0.04; // ad-hoc value
	$lower_lat = $center_lat - $range_h;
	$upper_lat = $center_lat + $range_h;
	$left_lon  = $center_lon - $range_w;
	$right_lon = $center_lon + $range_w;
	for ($page = 1 ; ; $page++) {
		$posts = new WP_Query("paged=$page");
		if (! $posts->have_posts() || $page > 100000) {
			break;
		}
		while ($posts->have_posts()) : $posts->the_post();
			list($lat, $lon) = $this->get_LatLon();
			if ($lat && $lon) {
				if ($lat == $center_lat && $lon == $center_lon) {
					$loc[0] = $this->infowindow($lat, $lon);
				} elseif ($lat >= $lower_lat && $lat <= $upper_lat && $lon >= $left_lon  && $lon <= $right_lon) {
					$loc[] = $this->infowindow($lat, $lon);
				}
			}
		endwhile;
	}
	if (count($loc[0]) < 1) {
		array_shift($loc);
	}
	return $loc;
}

// ==================================================
function categorized_locations($cat_id) {
	$cat_id = intval($cat_id);
	$loc = array();
	for ($page = 1 ; ; $page++) {
		$posts = new WP_Query("cat=$cat_id&paged=$page");
		if (! $posts->have_posts() || $page > 100000) {
			break;
		}
		while ($posts->have_posts()) : $posts->the_post();
			list($lat, $lon) = $this->get_LatLon();
			if ($lat && $lon) {
				$loc[] = $this->infowindow($lat, $lon);
			}
		endwhile;
	}
	return $loc;
}

// ==================================================
function recent_locations($max_num) {
	if ($max_num < 1) {
		$max_num = 100;
	}
	$loc = array();
	for ($page = 1 ; ; $page++) {
		$posts = new WP_Query("paged=$page");
		if (! $posts->have_posts() || $page > 100000) {
			break;
		}
		while ($posts->have_posts()) : $posts->the_post();
			list($lat, $lon) = $this->get_LatLon();
			if ($lat && $lon) {
				$loc[] = $this->infowindow($lat, $lon);
				if (count($loc) >= $max_num) {
					break 2;
				}
			}
		endwhile;
	}
	return $loc;
}

// ==================================================
function infowindow($lat, $lon) {
	$title = htmlspecialchars(get_the_title(), ENT_QUOTES);
	$link = get_permalink();
	$date = get_the_time('Y-m-d');
	$excerpt = preg_replace('/^\s+/', '', get_the_excerpt());
	$excerpt = preg_replace('/\n.*$/m', '', $excerpt);
	return compact('lat', 'lon', 'title', 'link', 'date', 'excerpt');
}

// ==================================================
function each_map($loc) {
	$zoom = get_option('lw_each_map_zoom');
	if (! $zoom) {
		$zoom = 14;
	}
	$map_type = get_option('lw_each_map_type');
	if (! $map_type) {
		$map_type = 'G_NORMAL_MAP';
	}
?>
<script type="text/javascript">
	//<![CDATA[
	onload = function() {
		var markeropt = new Object();
		markeropt.title = "<?php _e('Click to view my large map.', 'lw_googlemaps'); ?>";
<?php
	foreach ($loc as $id => $latlng) {
		echo <<<E__O__T
		var map$id = new GMap2(document.getElementById("map-$id"));
		map$id.setCenter(new GLatLng($latlng[0], $latlng[1]), $zoom, $map_type);
		map$id.addControl(new GSmallZoomControl());
		var marker$id = new GMarker(map$id.getCenter(), markeropt);
		GEvent.addListener(marker$id, "click", function() {location.href = "$latlng[2]"; });
		map$id.addOverlay(marker$id);

E__O__T;
	}
?>
	}
	onunload = GUnload;
	//]]>
	</script>
<?php
}

// ==================================================
function add_admin_page() {
	add_options_page('Lightweight Google Maps', 'Google Maps', 8, basename(__FILE__), array($this, 'admin_page'));
}

// ==================================================
function admin_page() {
	if (isset($_POST['info_update'])) {
		$yf_google_api_key = @$_POST['yf_google_api_key'];
		if ($yf_google_api_key) {
			update_option('yf_google_api_key', $yf_google_api_key);
		}
		$yf_google_page_id = @$_POST['yf_google_page_id'];
		if ($yf_google_page_id) {
			update_option('yf_google_page_id', $yf_google_page_id);
		}
		if ($_POST['lw_convert_geo_locations']) {
			$this->convert_geo_locations();
		}
		$yf_map_type = @$_POST['yf_map_type'];
		if ($yf_map_type) {
			update_option('yf_map_type', $yf_map_type);
		}
		$yf_zoom_level = intval(@$_POST['yf_zoom_level']);
		if ($yf_zoom_level || $yf_zoom_level==0) {
			update_option('yf_zoom_level', $yf_zoom_level);
		}
		$yf_google_width = intval(@$_POST['yf_google_width']);
		if ($yf_google_width) {
			update_option('yf_google_width', $yf_google_width);
		}
		$yf_google_height = intval(@$_POST['yf_google_height']);
		if ($yf_google_height) {
			update_option('yf_google_height', $yf_google_height);
		}
		$lw_num_recent_markers = intval(@$_POST['lw_num_recent_markers']);
		if ($lw_num_recent_markers) {
			update_option('lw_num_recent_markers', $lw_num_recent_markers);
		}
		$each_map_type = @$_POST['lw_each_map_type'];
		if ($each_map_type) {
			update_option('lw_each_map_type', $each_map_type);
		}
		$each_map_zoom = intval(@$_POST['lw_each_map_zoom']);
		if ($yf_zoom_level || $yf_zoom_level==0) {
			update_option('lw_each_map_zoom', $each_map_zoom);
		}
		$each_map_width = intval(@$_POST['lw_each_map_width']);
		if ($each_map_width) {
			update_option('lw_each_map_width', $each_map_width);
		}
		$each_map_height = intval(@$_POST['lw_each_map_height']);
		if ($each_map_height) {
			update_option('lw_each_map_height', $each_map_height);
		}
?><div class="updated fade"><p><strong><?php
		_e('Options saved.');
?></strong></p></div><?php
	}
	if (! isset($yf_map_type)) {
		$yf_map_type = get_option('yf_map_type');
	}
	$fixed_map_type_check = array();
	switch ($yf_map_type) {
	case 'G_NORMAL_MAP':
		$fixed_map_type_check[0] = ' checked="checked"';
		break;
	case 'G_SATELLITE_MAP':
		$fixed_map_type_check[1] = ' checked="checked"';
		break;
	case 'G_HYBRID_MAP':
		$fixed_map_type_check[2] = ' checked="checked"';
		break;
	}
	if (! isset($each_map_type)) {
		$each_map_type = get_option('lw_each_map_type');
	}
	$each_map_type_check = array();
	switch ($each_map_type) {
	case 'LWGM_LINK_TO_MAP':
		$each_map_type_check[1] = ' checked="checked"';
		break;
	case 'G_NORMAL_MAP':
		$each_map_type_check[2] = ' checked="checked"';
		break;
	case 'G_SATELLITE_MAP':
		$each_map_type_check[3] = ' checked="checked"';
		break;
	case 'G_HYBRID_MAP':
		$each_map_type_check[4] = ' checked="checked"';
		break;
	}
?><div class="wrap">
  <h2>Lightweight Google Maps</h2>
  <form method="post">
     <fieldset name="apikey" class="options">
        <legend><?php _e('Your Googlemap API Key', 'lw_googlemaps'); ?></legend>
        <table width="100%" cellspacing="2" cellpadding="5" class="editform"> 
		<tr>
		<th width="20%" scope="row"><label for="yf_google_api_key"><?php _e('API Key:', 'lw_googlemaps'); ?></label></th> 
		<td><input type="text" name="yf_google_api_key" id="yf_google_api_key" /> <?php echo sprintf(__('(don\'t have one? get one <a href=%s>here</a>)', 'lw_googlemaps'), '"http://www.google.com/apis/maps/signup.html"'); ?></td>
		</tr><tr>
        <th><?php _e('Current API Key:', 'lw_googlemaps'); ?></th>
		<td><em><?php echo get_option('yf_google_api_key'); ?></em></td>
		</tr>
		</table>
     </fieldset>
     <fieldset name="fixedpage" class="options">
        <legend><?php _e('Map on fixed pages', 'lw_googlemaps'); ?></legend>
        <table width="100%" cellspacing="2" cellpadding="5" class="editform"> 
		<tr> 
		<th width="20%" scope="row"><label for="yf_google_page_id"><?php _e('Page Slug:', 'lw_googlemaps'); ?></label></th> 
		<td>
		<input type="text" value="<?php echo get_option('yf_google_page_id');?>" name="yf_google_page_id" id="yf_google_page_id" />
        <div><?php _e('This is the wordpress page slug of your googlemap page. <em>Not sure what I mean?  Check the readme!</em>', 'lw_googlemaps'); ?></div>
		</td>
		</tr><tr> 
		<th width="20%" scope="row"><label for="yf_map_type"><?php _e('Type:', 'lw_googlemaps'); ?></label></th> 
		<td>
		<label><input type="radio" name="yf_map_type" id="yf_map_type" value="G_NORMAL_MAP"<?php echo $fixed_map_type_check[0]; ?> /> <?php _e('Graphic', 'lw_googlemaps'); ?></label>
		<label><input type="radio" name="yf_map_type" id="yf_map_type" value="G_SATELLITE_MAP"<?php echo $fixed_map_type_check[1]; ?> /> <?php _e('Satellite', 'lw_googlemaps'); ?></label>
		<label><input type="radio" name="yf_map_type" id="yf_map_type" value="G_HYBRID_MAP"<?php echo $fixed_map_type_check[2]; ?> /> <?php _e('Hybrid', 'lw_googlemaps'); ?></label>
		</td>
		</tr><tr>
		<th width="20%" scope="row"><label for="yf_zoom_level"><?php _e('Zoom Level:', 'lw_googlemaps'); ?></label></th>
		<td>
		<select name="yf_zoom_level" id="yf_zoom_level">
		<?php 
			$level_select = array();
			$level_select[intval(get_option('yf_zoom_level'))] = ' selected="selected"';
			for ($level = 19; $level >= 1; $level--) {
				echo '<option value="' . $level . '"' . $level_select[$level] . ">$level</option>\n";
			}
		?>
		</select>
		<span><?php _e('(1: Whole globe, Bigger: Narrower area)', 'lw_googlemaps'); ?></span>
		</td>
		</tr><tr>
		<th width="20%" scope="row"><label for="yf_google_width"><?php _e('Width:', 'lw_googlemaps'); ?></label></th> 
		<td>
		<input type="text" value="<?php echo get_option('yf_google_width');?>" name="yf_google_width" id="yf_google_width" /> px
		</td>
		</tr><tr>
		<th width="20%" scope="row"><label for="yf_google_height"><?php _e('Height:', 'lw_googlemaps'); ?></label></th> 
		<td>
		<input type="text" value="<?php echo get_option('yf_google_height');?>" name="yf_google_height" id="yf_google_height" /> px
		</td>
		</tr><tr>
		<th width="20%" scope="row"><label for="lw_num_recent_markers"><?php _e('Number of markers:', 'lw_googlemaps'); ?></label></th> 
		<td>
		<input type="text" value="<?php echo get_option('lw_num_recent_markers');?>" name="lw_num_recent_markers" id="lw_num_recent_markers" /> <?php _e('points', 'lw_googlemaps'); ?>
		</td>
		</tr>
		</table> 
     </fieldset>
     <fieldset name="eachmap" class="options">
        <legend><?php _e('Map for each entries', 'lw_googlemaps'); ?></legend>
        <table width="100%" cellspacing="2" cellpadding="5" class="editform"> 
		<tr> 
		<th width="20%" scope="row"><label for="lw_each_map_type"><?php _e('Type:', 'lw_googlemaps'); ?></label></th> 
		<td>
		<label><input type="radio" name="lw_each_map_type" id="lw_each_map_type" value="LWGM_LINK_TO_MAP"<?php echo $each_map_type_check[1]; ?> /> <?php _e('Link to my fixed map', 'lw_googlemaps'); ?></label>
		<label><input type="radio" name="lw_each_map_type" id="lw_each_map_type" value="G_NORMAL_MAP"<?php echo $each_map_type_check[2]; ?> /> <?php _e('Graphic', 'lw_googlemaps'); ?></label>
		<label><input type="radio" name="lw_each_map_type" id="lw_each_map_type" value="G_SATELLITE_MAP"<?php echo $each_map_type_check[3]; ?> /> <?php _e('Satellite', 'lw_googlemaps'); ?></label>
		<label><input type="radio" name="lw_each_map_type" id="lw_each_map_type" value="G_HYBRID_MAP"<?php echo $each_map_type_check[4]; ?> /> <?php _e('Hybrid', 'lw_googlemaps'); ?></label>
		</td>
		</tr><tr>
		<th width="20%" scope="row"><label for="lw_each_map_zoom"><?php _e('Zoom Level:', 'lw_googlemaps'); ?></label></th>
		<td>
		<select name="lw_each_map_zoom" id="lw_each_map_zoom">
		<?php 
			$level_select = array();
			$level_select[intval(get_option('lw_each_map_zoom'))] = ' selected="selected"';
			for ($level = 19; $level >= 1; $level--) {
				echo '<option value="' . $level . '"' . $level_select[$level] . ">$level</option>\n";
			}
		?>
		</select>
		<span><?php _e('(1: Whole globe, Bigger: Narrower area)', 'lw_googlemaps'); ?></span>
		</td>
		</tr><tr>
		<th width="20%" scope="row"><label for="lw_each_map_width"><?php _e('Width:', 'lw_googlemaps'); ?></label></th> 
		<td>
		<input type="text" value="<?php echo get_option('lw_each_map_width');?>" name="lw_each_map_width" id="lw_each_map_width" /> px
		</td>
		</tr><tr>
		<th width="20%" scope="row"><label for="lw_each_map_height"><?php _e('Height:', 'lw_googlemaps'); ?></label></th> 
		<td>
		<input type="text" value="<?php echo get_option('lw_each_map_height');?>" name="lw_each_map_height" id="lw_each_map_height" /> px
		</td>
		</tr>
		</table>
     </fieldset>
     <fieldset name="convertgeo" class="options">
        <legend><?php _e('Convert geo locations', 'lw_googlemaps'); ?></legend>
		<p><label>
		<input type="checkbox" value="1" name="lw_convert_geo_locations" id="lw_convert_geo_locations" /> <?php _e('Convert location data from Geo plug-in.', 'lw_googlemaps');?>
		</label></p>
		<p><?php _e('Notice: Please de-activate Geo plug-in and wp-eznavi plug-in BEFORE checking this option.', 'lw_googlemaps'); ?></p>
     </fieldset>
<div class="submit">
  <p><input type="submit" name="info_update" value="<?php
    _e('Update options');
        ?> &raquo;" /></div></p>
  </form>
 </div>
<?php
} 

// ==================================================
function convert_geo_locations() {
	global $wpdb;
	$wpdb->query("DELETE FROM {$wpdb->postmeta} WHERE meta_key = '_geo_location' AND meta_value = ','");
	$wpdb->query("UPDATE {$wpdb->postmeta} SET meta_key = 'Lat_Long' WHERE meta_key = '_geo_location'");
	return;
}

// ==================================================
} // End of class

?>