<?php
/*
Plugin Name: wp-mosquito
Plugin URI: http://wppluginsj.sourceforge.jp/wp-mosquito/
Description: The fastest, the lightest archive plugin for WordPress,
Author: hiromasa
Version: 1.00
Author URI: http://hiromasa.zone.ne.jp/blog/
Special Thanks: aka (http://plasticdreams.org/)
*/

/*  Copyright 2006 hiromasa  (email : webmaster@hiromasa.zone.ne.jp)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/******************************************************************************
 * WpMosquito
 * 
 * @author		hiromasa
 * @version		1.00
 * 
 *****************************************************************************/
class WpMosquito {
	
	/**
	 * WpMosquito action
	 * 
	 * @param none
	 * @return none
	 */
	function mosquito_archive() {
		
		global $wpdb;
		
		$query =
			"SELECT " .
				"distinct year(post_date) as year " .
			"FROM " .
				"$wpdb->posts " .
			"WHERE " .
				"post_status='publish' AND " .
				"post_date <= NOW() " .
			"ORDER BY " .
				"year desc;";
		$years = $wpdb->get_results($query);
		
		foreach($years as $year) {
			
			$query =
				"SELECT " .
					"*, year(post_date) as year, month(post_date) as month " .
				"FROM " .
					"$wpdb->posts " .
				"WHERE " .
					"year(post_date)='$year->year'  AND " .
					"post_status='publish'          AND " .
					"post_date <= NOW()" .
				"ORDER BY " .
					"post_date desc";
			$year_entrys = $wpdb->get_results($query);
			
			$outputYear = '';
			$outputMonth = '';
			$outputH2 = '';
			foreach($year_entrys as $entry) {
				
				if($outputYear != $entry->year) {
					$outputYear = $entry->year;
				}
				if($outputMonth != $entry->month) {
					$outputMonth = $entry->month;
					$lm = ucfirst(strftime("%B", strtotime("$outputMonth/01/2001")));
				}
				if($outputH2 != "<h2>$lm $outputYear</h2>\n") {
					if($outputH2 != '') echo "</ol>\n";
					$outputH2 = "<h2>$lm $outputYear</h2>\n";
					echo $outputH2;
					echo "<ol>\n";
				}
				
				$link = $this->get_permalink(
						$entry->post_date,
						$entry->ID,
						$entry->post_name);
				
				echo "<li><a href=\"$link\">$entry->post_title</a></li>\n";
				
			}
			echo "</ol>\n";
		}
		
	}
	
	/**
	 * Tiny get_permalink function (omit category & auther name)
	 * 
	 * @param none
	 * @return none
	 */
	function get_permalink($post_date, $id, $post_name) {
		
		$rewritecode = array(
			'%year%',
			'%monthnum%',
			'%day%',
			'%hour%',
			'%minute%',
			'%second%',
			'%postname%',
			'%post_id%',
			'%pagename%'
		);
		
		$permalink = get_settings('permalink_structure');
		
		if ('' != $permalink) {
			$unixtime = strtotime($post_date);
			$date = explode(" ",date('Y m d H i s', $unixtime));
			$rewritereplace = 
			array(
				$date[0],
				$date[1],
				$date[2],
				$date[3],
				$date[4],
				$date[5],
				$post_name,
				$id,
				$post_name,
			);
			$permalink =
				get_settings('home') .
				str_replace($rewritecode, $rewritereplace, $permalink);
			return $permalink;
		} else { // if they're not using the fancy permalink option
			$permalink = get_settings('home') . '/?p=' . $id;
			return $permalink;
		}
	}
	
}

$wpMosquito = & new WpMosquito();
add_action('mosquito_archive', array(&$wpMosquito, 'mosquito_archive'));

?>