/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.web;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

/**
 * 単純な{@link WebContext}実装です。
 * <br/>適用しているデザインパターン：変数を格納するだけの構造体。
 * @author nakamura
 *
 */
public class SimpleWebContext implements WebContext {
	private Map<String, List<Object>> input;
	private Map<String, Object> request;
	private ConcurrentMap<String, Object> session;
	private ConcurrentMap<String, Object> application;
	private Object container;
	
	public ConcurrentMap<String, Object> getApplication() {
		return application;
	}
	public void setApplication(final ConcurrentMap<String, Object> application) {
		this.application = application;
	}
	public Map<String, Object> getRequest() {
		return request;
	}
	public void setRequest(final Map<String, Object> request) {
		this.request = request;
	}
	public ConcurrentMap<String, Object> getSession() {
		return session;
	}
	public void setSession(final ConcurrentMap<String, Object> session) {
		this.session = session;
	}

	public Object getContainer() {
		return container;
	}
	public void setContainer(final Object container) {
		this.container = container;
	}
	public Map<String, List<Object>> getInput() {
		return input;
	}
	public void setInput(final Map<String, List<Object>> input) {
		this.input = input;
	}
}
