/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.util.Arrays;


import junit.framework.TestCase;

public class PermutationTest extends TestCase {
	public void testNormal4p2() {
		final int[] a = new int[2];
		final Permutation p = new Permutation(4, a);
		assertTrue(p.next());
		assertTrue(Arrays.equals(new int[]{0,1}, a));
		assertTrue(p.next());
		assertTrue(Arrays.equals(new int[]{0,2}, a));
		assertTrue(p.next());
		assertTrue(Arrays.equals(new int[]{0,3}, a));
		assertTrue(p.next());
		assertTrue(Arrays.equals(new int[]{1,0}, a));
		assertTrue(p.next());
		assertTrue(Arrays.equals(new int[]{1,2}, a));
		assertTrue(p.next());
		assertTrue(Arrays.equals(new int[]{1,3}, a));
		assertTrue(p.next());
		assertTrue(Arrays.equals(new int[]{2,0}, a));
		assertTrue(p.next());
		assertTrue(Arrays.equals(new int[]{2,1}, a));
		assertTrue(p.next());
		assertTrue(Arrays.equals(new int[]{2,3}, a));
		assertTrue(p.next());
		assertTrue(Arrays.equals(new int[]{3,0}, a));
		assertTrue(p.next());
		assertTrue(Arrays.equals(new int[]{3,1}, a));
		assertTrue(p.next());
		assertTrue(Arrays.equals(new int[]{3,2}, a));
		assertFalse(p.next());
	}
	public void testNormal2p2() {
		final int[] a = new int[2];
		final Permutation p = new Permutation(2, a);
		assertTrue(p.next());
		assertTrue(Arrays.equals(new int[]{0,1}, a));
		assertTrue(p.next());
		assertTrue(Arrays.equals(new int[]{1,0}, a));
		assertFalse(p.next());
	}
	public void testNormal1p1() {
		final int[] a = new int[1];
		final Permutation p = new Permutation(1, a);
		assertTrue(p.next());
		assertTrue(Arrays.equals(new int[]{0}, a));
		assertFalse(p.next());
	}
}
