/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.util.Arrays;

/**
 * 順列を表します。
 * @author nakamura
 *
 */
class Permutation {
	private final int n;
	private final int[] a;
	Permutation(final int n, final int[] a) {
		this.n = n;
		this.a = a;
		Arrays.fill(a, 0);
		a[a.length - 1] = -1;
	}
	boolean next() {
		return change(a.length - 1);
	}
	private boolean change(final int l) {
		if (l < 0) {
			return false;
		}
		if (++a[l] >= n) {
			a[l] = 0;
			if (!change(l - 1)) {
				return false;
			}
		}
		for (int i = 0; i < l; i++) {
			if (a[i] == a[l]) {
				return change(l);
			}
		}
		return true;
	}
}
