/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.List;

import junit.framework.TestCase;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.test.TestBean;

public class BeanUtilsTest extends TestCase {
	public void testTestBean() {
		final TestBean bean = new TestBean(3, new int[]{5, 7}, Arrays.asList(11, 13));
		final List<PropertyDescriptor> result = BeanUtils.getConstructorGetterList(bean);
		assertEquals(3, result.size());
		final int[] intArray = (int[])BeanUtils.get(bean, result.get(1).getReadMethod());
		assertEquals(Integer.valueOf(3), BeanUtils.get(bean, result.get(0).getReadMethod()));
		assertEquals(2, intArray.length);
		assertEquals(5, intArray[0]);
		assertEquals(7, intArray[1]);
		assertEquals(Arrays.asList(11, 13), BeanUtils.get(bean, result.get(2).getReadMethod()));
	}
	
	public void testDelegator() {
		final Fn<Object, String, RuntimeException> a = FnUtils.fix("a");
		final Fn<Object, String, RuntimeException> fn = FnUtils.delegate(a);
		final List<PropertyDescriptor> result = BeanUtils.getConstructorGetterList(fn);
		assertEquals(1, result.size());
		assertEquals(a, BeanUtils.get(fn, result.get(0).getReadMethod()));
	}
}
