/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.typeconvert;

import woolpack.fn.Fn;

/**
 * {@link ConvertContext#getToType()}を委譲先で変換した結果を
 * {@link ConvertContext#setToType(Class)}に設定する関数です。
 * <br/>適用しているデザインパターン：参照透過と副作用のAdapter。
 * @author nakamura
 *
 */
public class ToTypeConverter implements Fn<ConvertContext, Void, RuntimeException> {
	private Fn<? super Class, ? extends Class, ? extends RuntimeException> fn;
	
	public ToTypeConverter(
			final Fn<? super Class, ? extends Class, ? extends RuntimeException> fn) {
		this.fn = fn;
	}
	
	public Void exec(final ConvertContext c) {
		c.setToType(fn.exec(c.getToType()));
		return null;
	}

	public Fn<? super Class, ? extends Class, ? extends RuntimeException> getFn() {
		return fn;
	}
	public void setFn(final Fn<? super Class, ? extends Class, ? extends RuntimeException> fn) {
		this.fn = fn;
	}
}
