/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.sql.fn;

import java.util.List;

/**
 * {@link java.sql.PreparedStatement}に値を設定するためのクエリ情報を表します。
 * <br/>適用しているデザインパターン：変数を格納するだけの構造体。
 * @author nakamura
 *
 */
public class PreparedStatementInfo {
	private String query;
	private List<String> list;
	
	/**
	 * 
	 * @param query クエリ。
	 * @param list 入力と{@link java.sql.PreparedStatement}を対応させるリスト。
	 */
	public PreparedStatementInfo(final String query, final List<String> list) {
		this.query = query;
		this.list = list;
	}
	
	public PreparedStatementInfo() {
	}

	public List<String> getList() {
		return list;
	}
	public void setList(final List<String> list) {
		this.list = list;
	}
	public String getQuery() {
		return query;
	}
	public void setQuery(final String query) {
		this.query = query;
	}
}
