/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.sql.adapter;

import java.sql.SQLException;
import java.sql.Statement;

import junit.framework.TestCase;
import woolpack.test.TestUtils;

public class StatementAdapterTest extends TestCase {
	public void testNormal() throws SQLException {
		final StatementAdapter o = new StatementAdapter(TestUtils.newProxyInstance(
				Statement.class,
				TestUtils.getMockHandler()
		));
		
		String sql = null;
		String[] autoGeneratedKeys = null;
		int[] columnIndexes = null;
		String[] columnNames = null;
		String name = null;
		boolean enable = false;
		int direction = 0;
		int rows = 0;
		int max = 0;
		int seconds = 0;
		int current = 0;
		
		o.addBatch(sql);
		o.cancel();
		o.clearBatch();
		o.clearWarnings();
		o.close();
		o.setCursorName(name);
		o.setEscapeProcessing(enable);
		o.setFetchDirection(direction);
		o.setFetchSize(rows);
		o.setMaxFieldSize(max);
		o.setMaxRows(max);
		o.setQueryTimeout(seconds);
		o.execute(sql, autoGeneratedKeys);
		o.execute(sql, columnIndexes);
		o.execute(sql, columnNames);
		o.execute(sql);
		o.executeBatch();
		o.executeQuery(sql);
		o.executeUpdate(sql, autoGeneratedKeys);
		o.executeUpdate(sql, columnIndexes);
		o.executeUpdate(sql, columnNames);
		o.executeUpdate(sql);
		o.getConnection();
		o.getFetchDirection();
		o.getFetchSize();
		o.getGeneratedKeys();
		o.getMaxFieldSize();
		o.getMaxRows();
		o.getMoreResults();
		o.getMoreResults(current);
		o.getQueryTimeout();
		o.getResultSet();
		o.getResultSetConcurrency();
		o.getResultSetHoldability();
		o.getResultSetType();
		o.getUpdateCount();
		o.getWarnings();




		o.getParent();
		o.setParent(null);
	}
}
