/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.sql.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Map;

import junit.framework.TestCase;
import woolpack.test.TestUtils;

public class ConnectionAdapterTest extends TestCase {
	public void testNormal() throws SQLException {
		final ConnectionAdapter o = new ConnectionAdapter(TestUtils.newProxyInstance(
				Connection.class,
				TestUtils.getMockHandler()
		));
		
		int resultSetType = 0;
		int resultSetConcurrency = 0;
		int resultSetHoldability = 0;
		String sql = null;
		String[] autoGeneratedKeys = null;
		int[] columnIndexes = null;
		String[] columnNames = null;
		Savepoint savepoint = null;
		boolean autoCommit = false;
		String catalog = null;
		int holdability = 0;
		boolean readOnly = false;
		String name = null;
		int level = 0;
		Map<String,Class<?>> map = null;
		
		
		o.clearWarnings();
		o.close();
		o.commit();
		o.createStatement();
		o.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
		o.createStatement(resultSetType, resultSetConcurrency);
		o.getAutoCommit();
		o.getCatalog();
		o.getHoldability();
		o.getMetaData();
		o.getTransactionIsolation();
		o.getTypeMap();
		o.getWarnings();
		o.isClosed();
		o.isReadOnly();
		o.nativeSQL(sql);
		o.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
		o.prepareCall(sql, resultSetType, resultSetConcurrency);
		o.prepareCall(sql);
		o.prepareStatement(sql, autoGeneratedKeys);
		o.prepareStatement(sql, columnIndexes);
		o.prepareStatement(sql, columnNames);
		o.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
		o.prepareStatement(sql, resultSetType, resultSetConcurrency);
		o.prepareStatement(sql);
		o.releaseSavepoint(savepoint);
		o.rollback();
		o.rollback(savepoint);
		o.setAutoCommit(autoCommit);
		o.setCatalog(catalog);
		o.setHoldability(holdability);
		o.setReadOnly(readOnly);
		o.setSavepoint();
		o.setSavepoint(name);
		o.setTransactionIsolation(level);
		o.setTypeMap(map);


		o.getParent();
		o.setParent(null);
	}
}
