/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.sql;

import java.util.Arrays;

import junit.framework.TestCase;
import woolpack.sql.convert.SqlCommentUtils;
import woolpack.sql.fn.PreparedStatementInfo;

public class SqlCommentUtilsTest extends TestCase {
	
	public void testToPreparedStatementInfo1() {
		final PreparedStatementInfo info = SqlCommentUtils.toPreparedStatementInfo(
				"select * from table where /* conditions */ col0 = /*col0 */ and col1 = /*col1 */");
		assertEquals("select * from table where  col0 = ? and col1 = ?", info.getQuery());
		assertEquals(Arrays.asList("col0", "col1"), info.getList());
	}
	
	public void testToPreparedStatementInfo2() {
		final PreparedStatementInfo info = SqlCommentUtils.toPreparedStatementInfo(
				"select * from table where /* conditions */ col0 = 11/*col0*/ and col1 = /*col1*/'hona'");
		assertEquals("select * from table where  col0 = ? and col1 = ?", info.getQuery());
		assertEquals(Arrays.asList("col0", "col1"), info.getList());
	}
	
	public void testToPreparedStatementInfo3() {
		final PreparedStatementInfo info = SqlCommentUtils.toPreparedStatementInfo(
				"update table set col1 = /*col1*/'a', col2 = /*col2*/'a' where /* conditions */ col0 = /*col0*/'a'");
		assertEquals("update table set col1 = ?, col2 = ? where  col0 = ?", info.getQuery());
		assertEquals(Arrays.asList("col1", "col2", "col0"), info.getList());
	}
	
	public void testToPreparedStatementInfo4() {
		final PreparedStatementInfo info = SqlCommentUtils.toPreparedStatementInfo(
				"select * from table where /* conditions */ " +
				"col0 =/*col0 */ and " +
				"col1 </*col1 */ and " +
				"col2 >/*col2*/ and " +
				"col3 like (/*col31*/||/*col32*/)");
		assertEquals("select * from table where  col0 =? and col1 <? and col2 >? and col3 like (?||?)", info.getQuery());
		assertEquals(Arrays.asList("col0", "col1", "col2", "col31", "col32"), info.getList());
	}
}
