/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

/**
 * コンテキストに値を設定せず、内部に値を保持する式言語です。
 * このクラスは複数のスレッドから同時に使用した場合は安全ではありません。
 * @author nakamura
 *
 */
public class StateEL extends AbstractEL {
	private Object value;

	@Override
	public Object getValue(final Object root, final Class toType) {
		return ELUtils.THIS.getValue(value, toType);
	}

	@Override
	public boolean setValue(final Object root, final Object value) {
		this.value = value;
		return true;
	}
}
