/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;


/**
 * プロパティ式言語ファクトリの結果に対して作用させる式言語です。
 * <br/>適用しているデザインパターン：プロパティ名と作用対象オブジェクトのCurrying。
 * 
 * @author nakamura
 * 
 */
public class PropertyEL extends AbstractEL {
	private String propertyName;
	private PropertyELFactory factory;

	/**
	 * @param propertyName プロパティ名。
	 * @param factory プロパティ式言語ファクトリ。
	 */
	public PropertyEL(
			final String propertyName,
			final PropertyELFactory factory) {
		super();
		this.propertyName = propertyName;
		this.factory = factory;
	}

	/**
	 * @param propertyName プロパティ名。
	 */
	public PropertyEL(final String propertyName) {
		this(propertyName, ELUtils.PROPERTY_EL_FACTORY);
	}

	@Override
	public Object getValue(final Object root, final Class clazz) {
		return factory.newGetter(root.getClass(), propertyName).getValue(root,
				clazz);
	}

	@Override
	public boolean setValue(final Object root, final Object value) {
		return factory.newSetter(root.getClass(), propertyName).setValue(root, value);
	}

	public PropertyELFactory getFactory() {
		return factory;
	}
	public void setFactory(final PropertyELFactory factory) {
		this.factory = factory;
	}
	public String getPropertyName() {
		return propertyName;
	}
	public void setPropertyName(final String propertyName) {
		this.propertyName = propertyName;
	}
}
