/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

/**
 * 作用の基点がヌルでない場合に委譲する式言語です。
 * <br/>適用しているデザインパターン：作用の基点がヌルの場合はBalkingする。
 * @author nakamura
 *
 */
public class MaybeEL extends AbstractEL {
	private EL el;
	
	public MaybeEL(final EL el) {
		this.el = el;
	}

	@Override
	public Object getValue(final Object root, final Class toType) {
		if (root == null) {
			return null;
		} else {
			return el.getValue(root, toType);
		}
	}
	
	@Override
	public boolean setValue(final Object root, final Object value) {
		if (root == null) {
			return false;
		} else {
			return el.setValue(root, value);
		}
	}

	public EL getEl() {
		return el;
	}
	public void setEl(final EL el) {
		this.el = el;
	}
}
