/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import junit.framework.TestCase;

public class FixELTest extends TestCase {
	public void testNormal() {
		assertNull(new FixEL(null).getValue(null));
		assertNull(new FixEL(null).getValue(new Object()));
		assertNull(new FixEL(null).getValue(null, String.class));
		assertNull(new FixEL(null).getValue(new Object(), String.class));

		assertEquals("value0", new FixEL("value0").getValue(null));
		assertEquals("value0", new FixEL("value0").getValue(new Object()));
		assertEquals("value0", new FixEL("value0").getValue(null, String.class));
		assertEquals("value0", new FixEL("value0").getValue(new Object(),
				String.class));

		assertEquals(Integer.valueOf(3), new FixEL(Integer.valueOf(3)).getValue(null));
		assertEquals(Integer.valueOf(3), new FixEL(Integer.valueOf(3))
				.getValue(new Object()));
		assertEquals("3", new FixEL(Integer.valueOf(3)).getValue(null, String.class));
		assertEquals("3", new FixEL(Integer.valueOf(3)).getValue(new Object(), String.class));

		assertFalse(new FixEL(null).setValue(new Object(), new Object()));
	}
}
