/*
 * Decompiled with CFR 0.152.
 */
package woolpack.utils.fn;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import woolpack.fn.Fn;
import woolpack.utils.PropertyUtils;
import woolpack.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UtilsFnUtils {
    public static final Fn<Object, List<Object>, RuntimeException> ARRAY_TO_LIST = new Fn<Object, List<Object>, RuntimeException>(){

        @Override
        public List<Object> exec(Object c) throws RuntimeException {
            return Utils.arrayToList(c);
        }
    };
    public static final Fn<Object, Iterable<?>, RuntimeException> TO_ITERABLE = new Fn<Object, Iterable<?>, RuntimeException>(){

        @Override
        public Iterable<?> exec(Object c) throws RuntimeException {
            return Utils.toIterable(c);
        }
    };
    public static final Fn<Object, Collection<?>, RuntimeException> TO_COLLECTION = new Fn<Object, Collection<?>, RuntimeException>(){

        @Override
        public Collection<?> exec(Object c) throws RuntimeException {
            return Utils.toCollection(c);
        }
    };
    public static final Fn<Object, List<?>, RuntimeException> TO_LIST = new Fn<Object, List<?>, RuntimeException>(){

        @Override
        public List<?> exec(Object c) throws RuntimeException {
            return Utils.toList(c);
        }
    };
    public static final Fn<Throwable, List<String>, RuntimeException> TO_MESSAGE_LIST = new Fn<Throwable, List<String>, RuntimeException>(){

        @Override
        public List<String> exec(Throwable c) throws RuntimeException {
            return Utils.toMessageList(c);
        }
    };
    public static final Fn<String, Iterable<String>, RuntimeException> PROPERTY_GUESSING_FACTORY = UtilsFnUtils.getPropertyGuessingIterable('_');

    private UtilsFnUtils() {
    }

    public static <K, V> Fn<Map<K, V>, Map<V, K>, RuntimeException> inverseMap() {
        return new Fn<Map<K, V>, Map<V, K>, RuntimeException>(){

            @Override
            public Map<V, K> exec(Map<K, V> c) throws RuntimeException {
                return Utils.inverseMap(c);
            }
        };
    }

    public static <K, V> Fn<Map<K, V>, Map<K, V>, RuntimeException> injectiveMap() {
        return new Fn<Map<K, V>, Map<K, V>, RuntimeException>(){

            @Override
            public Map<K, V> exec(Map<K, V> c) throws RuntimeException {
                return Utils.injectiveMap(c);
            }
        };
    }

    public static <K, V> Fn<Map<K, V>, Map<K, V>, RuntimeException> unoverwritableMap() {
        return new Fn<Map<K, V>, Map<K, V>, RuntimeException>(){

            @Override
            public Map<K, V> exec(Map<K, V> c) throws RuntimeException {
                return Utils.unoverwritableMap(c);
            }
        };
    }

    public static <K, V> Fn<Map<K, V>, Map<K, V>, RuntimeException> notNullMap() {
        return new Fn<Map<K, V>, Map<K, V>, RuntimeException>(){

            @Override
            public Map<K, V> exec(Map<K, V> c) throws RuntimeException {
                return Utils.notNullMap(c);
            }
        };
    }

    public static <V> Fn<Map<String, V>, Map<String, V>, RuntimeException> keyNotEmptyMap() {
        return new Fn<Map<String, V>, Map<String, V>, RuntimeException>(){

            @Override
            public Map<String, V> exec(Map<String, V> c) throws RuntimeException {
                return Utils.keyNotEmptyMap(c);
            }
        };
    }

    public static <V> Fn<Map<String, V>, Map<String, V>, RuntimeException> similarKeyMap() {
        return new Fn<Map<String, V>, Map<String, V>, RuntimeException>(){

            @Override
            public Map<String, V> exec(Map<String, V> c) throws RuntimeException {
                return Utils.similarKeyMap(c);
            }
        };
    }

    public static <E> Fn<Iterable<E>, Iterable<E>, RuntimeException> unmodifiableIterable() {
        return new Fn<Iterable<E>, Iterable<E>, RuntimeException>(){

            @Override
            public Iterable<E> exec(Iterable<E> c) throws RuntimeException {
                return Utils.unmodifiableIterable(c);
            }
        };
    }

    public static Fn<String, Iterable<String>, RuntimeException> getPropertyGuessingIterable(final char separator) {
        return new Fn<String, Iterable<String>, RuntimeException>(){

            @Override
            public Iterable<String> exec(String c) throws RuntimeException {
                return PropertyUtils.getGuessingIterable(c, separator);
            }
        };
    }
}

