/*
 * Decompiled with CFR 0.152.
 */
package woolpack.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import woolpack.utils.Permutation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanUtils {
    private static final Pattern LOCAL_CLASS_NAME = Pattern.compile("([^\\.]+\\.)*([^\\.]*)");

    private BeanUtils() {
    }

    public static String getLocalClassName(Class clazz) {
        Matcher m = LOCAL_CLASS_NAME.matcher(clazz.getName());
        m.matches();
        return m.group(2);
    }

    public static Object get(Object object, Method method) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static List<PropertyDescriptor> getGetterList(Class clazz) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e);
        }
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>(beanInfo.getPropertyDescriptors().length);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = 0;
        int n2 = propertyDescriptorArray.length;
        while (n < n2) {
            String key;
            PropertyDescriptor p = propertyDescriptorArray[n];
            Method m = p.getReadMethod();
            if (m != null && !"class".equals(key = p.getName())) {
                list.add(p);
            }
            ++n;
        }
        return list;
    }

    public static List<PropertyDescriptor> getConstructorGetterList(Object object) {
        Class<?> clazz = object.getClass();
        List<PropertyDescriptor> getterList = BeanUtils.getGetterList(clazz);
        int length = getterList.size();
        Class[] baseClassArray = new Class[length];
        Object[] baseValueArray = new Object[length];
        int i = 0;
        while (i < length) {
            PropertyDescriptor p = getterList.get(i);
            baseClassArray[i] = p.getPropertyType();
            baseValueArray[i] = BeanUtils.get(object, p.getReadMethod());
            ++i;
        }
        Object[] tmpClassArray = new Class[length];
        Object[] tmpValueArray = new Object[length];
        int[] a = new int[length];
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = 0;
        int n2 = constructorArray.length;
        while (n < n2) {
            Constructor<?> constructor = constructorArray[n];
            Object[] classArray = constructor.getParameterTypes();
            if (classArray.length == length) {
                if (classArray.length == 0) {
                    if (length == 0) {
                        return Collections.emptyList();
                    }
                } else {
                    Permutation pe = new Permutation(length, a);
                    block7: while (pe.next()) {
                        Object newObject;
                        int i2 = 0;
                        while (i2 < length) {
                            tmpClassArray[i2] = baseClassArray[a[i2]];
                            ++i2;
                        }
                        if (!Arrays.equals(classArray, tmpClassArray)) continue;
                        i2 = 0;
                        while (i2 < length) {
                            tmpValueArray[i2] = baseValueArray[a[i2]];
                            ++i2;
                        }
                        try {
                            newObject = constructor.newInstance(tmpValueArray);
                        }
                        catch (IllegalArgumentException e) {
                            continue;
                        }
                        catch (InstantiationException e) {
                            continue;
                        }
                        catch (IllegalAccessException e) {
                            continue;
                        }
                        catch (InvocationTargetException e) {
                            continue;
                        }
                        int i3 = 0;
                        while (i3 < length) {
                            PropertyDescriptor p = getterList.get(i3);
                            Object o0 = baseValueArray[i3];
                            Object o1 = BeanUtils.get(newObject, p.getReadMethod());
                            if (o0 == null ? o1 != null : !o0.equals(o1)) continue block7;
                            ++i3;
                        }
                        ArrayList<PropertyDescriptor> newList = new ArrayList<PropertyDescriptor>();
                        int i4 = 0;
                        while (i4 < length) {
                            newList.add(getterList.get(a[i4]));
                            ++i4;
                        }
                        return newList;
                    }
                }
            }
            ++n;
        }
        throw new IllegalArgumentException("not match constructor and parameter : " + object);
    }
}

