/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.fn;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import woolpack.el.EL;
import woolpack.el.ELUtils;
import woolpack.el.GettingEL;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.sql.fn.PreparedStatementInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlFnUtils {
    public static final Fn<Statement, Integer, SQLException> GET_COUNT = new Fn<Statement, Integer, SQLException>(){

        @Override
        public Integer exec(Statement c) throws SQLException {
            return c.getUpdateCount();
        }
    };
    public static final Fn<ResultSet, Object, SQLException> GET_SINGLE = new Fn<ResultSet, Object, SQLException>(){

        @Override
        public Object exec(ResultSet c) throws SQLException {
            return c.getObject(1);
        }
    };

    private SqlFnUtils() {
    }

    public static <R> Fn<ResultSet, R, Exception> getBeanResult(Fn<? super ResultSet, ? extends R, ? extends Exception> beanFactory) {
        return SqlFnUtils.getBeanResult(beanFactory, ELUtils.EL_FACTORY);
    }

    public static <R> Fn<ResultSet, R, Exception> getBeanResult(final Fn<? super ResultSet, ? extends R, ? extends Exception> beanFactory, final Fn<String, EL, ? extends Exception> elFactory) {
        return new Fn<ResultSet, R, Exception>(){

            @Override
            public R exec(ResultSet c) throws Exception {
                Object r = beanFactory.exec(c);
                ResultSetMetaData metaData = c.getMetaData();
                int length = metaData.getColumnCount();
                int i = 0;
                while (i < length) {
                    ((EL)elFactory.exec(metaData.getColumnName(i + 1))).setValue(r, c.getObject(i + 1));
                    ++i;
                }
                return r;
            }
        };
    }

    public static <R> Fn<Statement, List<R>, Exception> getList(final Fn<? super ResultSet, ? extends R, ? extends Exception> rowFn, final int max, final Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        return new Fn<Statement, List<R>, Exception>(){

            @Override
            public List<R> exec(Statement c) throws Exception {
                SQLException e0;
                block10: {
                    ArrayList arrayList;
                    e0 = null;
                    ResultSet resultSet = c.getResultSet();
                    try {
                        ArrayList list = new ArrayList();
                        int i = 0;
                        while (resultSet.next()) {
                            if (++i > max) break;
                            list.add(rowFn.exec(resultSet));
                        }
                        arrayList = list;
                    }
                    catch (SQLException e1) {
                        try {
                            try {
                                errorFn.exec(e1);
                                e0 = e1;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                resultSet.close();
                            }
                        }
                        catch (SQLException e12) {
                            errorFn.exec(e12);
                            if (e0 != null) break block10;
                            e0 = e12;
                        }
                    }
                    resultSet.close();
                    return arrayList;
                }
                if (e0 != null) {
                    throw e0;
                }
                return null;
            }
        };
    }

    public static <R> Fn<Statement, List<R>, Exception> getList(Fn<? super ResultSet, ? extends R, ? extends Exception> fn, Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        return SqlFnUtils.getList(fn, Integer.MAX_VALUE, errorFn);
    }

    public static <C, R> Fn<C, R, Exception> inputBean(final DataSource dataSource, final Fn<? super C, ? extends PreparedStatementInfo, ? extends Exception> queryFactory, final Fn<? super PreparedStatement, ? extends R, ? extends Exception> converter, final Fn<? super SQLException, ?, ? extends Exception> errorFn, final Fn<String, ? extends GettingEL, ? extends Exception> elFactory) {
        return new Fn<C, R, Exception>(){

            /*
             * Loose catch block
             * Enabled aggressive exception aggregation
             */
            @Override
            public R exec(C c) throws Exception {
                SQLException e0;
                block16: {
                    e0 = null;
                    try {
                        Connection connection = dataSource.getConnection();
                        PreparedStatementInfo info = (PreparedStatementInfo)queryFactory.exec(c);
                        PreparedStatement statement = connection.prepareStatement(info.getQuery());
                        int i = 0;
                        while (i < info.getList().size()) {
                            String propertyName = info.getList().get(i);
                            Iterable iterable = (Iterable)((GettingEL)elFactory.exec(propertyName)).getValue(c, Iterable.class);
                            Iterator iterator = iterable.iterator();
                            statement.setObject(i + 1, iterator.hasNext() ? iterator.next() : null);
                            ++i;
                        }
                        statement.execute();
                        Object r = converter.exec(statement);
                        statement.close();
                        connection.close();
                        return r;
                        {
                            catch (SQLException e1) {
                                try {
                                    try {
                                        try {
                                            errorFn.exec(e1);
                                            e0 = e1;
                                        }
                                        catch (Throwable throwable) {
                                            throw throwable;
                                        }
                                        finally {
                                            statement.close();
                                        }
                                    }
                                    catch (SQLException e12) {
                                        errorFn.exec(e12);
                                        if (e0 == null) {
                                            e0 = e12;
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    connection.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e1) {
                        errorFn.exec(e1);
                        if (e0 != null) break block16;
                        e0 = e1;
                    }
                }
                if (e0 != null) {
                    throw e0;
                }
                return null;
            }
        };
    }

    public static <C, R> Fn<C, R, Exception> inputBean(DataSource dataSource, Fn<? super C, ? extends PreparedStatementInfo, ? extends Exception> queryFactory, Fn<? super PreparedStatement, ? extends R, ? extends Exception> converter, Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        return SqlFnUtils.inputBean(dataSource, queryFactory, converter, errorFn, ELUtils.EL_FACTORY);
    }

    public static <C, R> Fn<C, R, Exception> inputBean(DataSource dataSource, PreparedStatementInfo info, Fn<? super PreparedStatement, ? extends R, ? extends Exception> converter, Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        return SqlFnUtils.inputBean(dataSource, FnUtils.fix(info), converter, errorFn);
    }

    public static <R> Fn<Statement, R, Exception> getOne(final Fn<? super ResultSet, ? extends R, ? extends Exception> rowFn, final Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        return new Fn<Statement, R, Exception>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public R exec(Statement c) throws Exception {
                SQLException e0;
                block7: {
                    e0 = null;
                    try {
                        ResultSet resultSet = c.getResultSet();
                        try {
                            if (!resultSet.next()) return null;
                            Object r = rowFn.exec(resultSet);
                            return r;
                        }
                        catch (SQLException e1) {
                            errorFn.exec(e1);
                            e0 = e1;
                        }
                        finally {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e12) {
                        errorFn.exec(e12);
                        if (e0 != null) break block7;
                        e0 = e12;
                    }
                }
                if (e0 == null) return null;
                throw e0;
            }
        };
    }

    public static <C, R> Fn<C, R, Exception> inputSingle(final DataSource dataSource, final Fn<? super C, ? extends String, ? extends Exception> queryFactory, final Fn<? super PreparedStatement, ? extends R, ? extends Exception> converter, final Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        return new Fn<C, R, Exception>(){

            /*
             * Loose catch block
             * Enabled aggressive exception aggregation
             */
            @Override
            public R exec(C c) throws Exception {
                SQLException e0;
                block15: {
                    e0 = null;
                    try {
                        Connection connection = dataSource.getConnection();
                        PreparedStatement statement = connection.prepareStatement((String)queryFactory.exec(c));
                        statement.setObject(1, c);
                        statement.execute();
                        Object r = converter.exec(statement);
                        statement.close();
                        connection.close();
                        return r;
                        {
                            catch (SQLException e1) {
                                try {
                                    try {
                                        try {
                                            errorFn.exec(e1);
                                            e0 = e1;
                                        }
                                        catch (Throwable throwable) {
                                            throw throwable;
                                        }
                                        finally {
                                            statement.close();
                                        }
                                    }
                                    catch (SQLException e12) {
                                        errorFn.exec(e12);
                                        if (e0 == null) {
                                            e0 = e12;
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    connection.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e1) {
                        errorFn.exec(e1);
                        if (e0 != null) break block15;
                        e0 = e1;
                    }
                }
                if (e0 != null) {
                    throw e0;
                }
                return null;
            }
        };
    }

    public static <C, R> Fn<C, R, Exception> inputSingle(DataSource dataSource, String query, Fn<? super PreparedStatement, ? extends R, ? extends Exception> converter, Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        return SqlFnUtils.inputSingle(dataSource, FnUtils.fix(query), converter, errorFn);
    }

    public static <C, R> Fn<C, R, Exception> inputStatement(final DataSource dataSource, final Fn<? super C, ? extends String, ? extends Exception> queryFactory, final Fn<? super Statement, ? extends R, ? extends Exception> converter, final Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        return new Fn<C, R, Exception>(){

            /*
             * Loose catch block
             * Enabled aggressive exception aggregation
             */
            @Override
            public R exec(C c) throws Exception {
                SQLException e0;
                block15: {
                    e0 = null;
                    try {
                        Connection connection = dataSource.getConnection();
                        Statement statement = connection.createStatement();
                        statement.execute((String)queryFactory.exec(c));
                        Object r = converter.exec(statement);
                        statement.close();
                        connection.close();
                        return r;
                        {
                            catch (SQLException e1) {
                                try {
                                    try {
                                        try {
                                            errorFn.exec(e1);
                                            e0 = e1;
                                        }
                                        catch (Throwable throwable) {
                                            throw throwable;
                                        }
                                        finally {
                                            statement.close();
                                        }
                                    }
                                    catch (SQLException e12) {
                                        errorFn.exec(e12);
                                        if (e0 == null) {
                                            e0 = e12;
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    connection.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e1) {
                        errorFn.exec(e1);
                        if (e0 != null) break block15;
                        e0 = e1;
                    }
                }
                if (e0 != null) {
                    throw e0;
                }
                return null;
            }
        };
    }

    public static <C, R> Fn<C, R, Exception> inputStatement(DataSource dataSource, String query, Fn<? super Statement, ? extends R, ? extends Exception> converter, Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        return SqlFnUtils.inputStatement(dataSource, FnUtils.fix(query), converter, errorFn);
    }
}

