/*
 * Decompiled with CFR 0.152.
 */
package woolpack.idweb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import woolpack.el.EL;
import woolpack.fn.Fn;
import woolpack.id.IdContext;
import woolpack.validator.AddressedMessage;
import woolpack.validator.AddressedMessageCollector;
import woolpack.validator.ValidatorContext;
import woolpack.web.WebContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IdWebUtils {
    private IdWebUtils() {
    }

    public static <C extends WebContext & IdContext, E extends Exception> Fn<C, Void, E> validate(final Fn<? super ValidatorContext, Boolean, ? extends E> validatorFn, final Fn<? super C, Void, ? extends E> trueFn, final Fn<? super C, Void, ? extends E> falseFn, final Fn<? super List<AddressedMessage>, ?, ? extends E> messageListConverter, final EL messageListSetter, final boolean convertDelegateFlag, final boolean convertReturnFlag) {
        return new Fn<C, Void, E>(){

            @Override
            public Void exec(C c) throws Exception {
                ValidatorContext validatorContext = new ValidatorContext();
                AddressedMessageCollector collector = new AddressedMessageCollector();
                validatorContext.setCollectable(collector);
                validatorContext.setId(c.getId());
                Map<String, List<Object>> beforeMap = c.getInput();
                HashMap<String, List<Object>> afterMap = new HashMap<String, List<Object>>();
                for (Map.Entry<String, List<Object>> entry : beforeMap.entrySet()) {
                    afterMap.put(entry.getKey(), new ArrayList(entry.getValue()));
                }
                validatorContext.setInputMap(afterMap);
                try {
                    boolean result = (Boolean)validatorFn.exec(validatorContext);
                    c.setInput(convertDelegateFlag ? afterMap : beforeMap);
                    if (result) {
                        trueFn.exec(c);
                    } else {
                        messageListSetter.setValue(c, messageListConverter.exec(collector.getList()));
                        falseFn.exec(c);
                    }
                }
                catch (Throwable throwable) {
                    c.setInput(convertReturnFlag ? afterMap : beforeMap);
                    throw throwable;
                }
                c.setInput(convertReturnFlag ? afterMap : beforeMap);
                return null;
            }
        };
    }
}

