/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import woolpack.el.AbstractEL;
import woolpack.el.AbstractGettingEL;
import woolpack.el.EL;
import woolpack.el.ELTargetRuntimeException;
import woolpack.el.GettingEL;
import woolpack.el.PropertyELFactory;
import woolpack.el.PropertyNotFoundException;
import woolpack.fn.Fn;
import woolpack.typeconvert.ConvertContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionPropertyELFactory
implements PropertyELFactory {
    private Fn<ConvertContext, Void, ? extends RuntimeException> fn;

    public ReflectionPropertyELFactory(Fn<ConvertContext, Void, ? extends RuntimeException> fn) {
        this.fn = fn;
    }

    private BeanInfo generateBeanInfo(Class clazz) {
        try {
            return Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public GettingEL newGetter(final Class clazz, final String propertyName) {
        BeanInfo beanInfo = this.generateBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = 0;
        int n2 = propertyDescriptorArray.length;
        while (n < n2) {
            PropertyDescriptor p = propertyDescriptorArray[n];
            if (p.getName().equals(propertyName)) {
                final Method m = p.getReadMethod();
                if (m == null) break;
                return new AbstractGettingEL(){

                    public Object getValue(Object root, Class toType) {
                        try {
                            Object result = m.invoke(root, new Object[0]);
                            ConvertContext context = new ConvertContext();
                            context.setPropertyName(propertyName);
                            context.setToType(toType);
                            context.setValue(result);
                            ReflectionPropertyELFactory.this.fn.exec(context);
                            return context.getValue();
                        }
                        catch (IllegalAccessException e) {
                            throw new IllegalStateException("error at " + clazz + " " + propertyName, e);
                        }
                        catch (InvocationTargetException e) {
                            throw new ELTargetRuntimeException(e);
                        }
                    }
                };
            }
            ++n;
        }
        throw new PropertyNotFoundException("property not found for " + clazz + ':' + propertyName);
    }

    @Override
    public EL newSetter(final Class clazz, final String propertyName) {
        BeanInfo beanInfo = this.generateBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = 0;
        int n2 = propertyDescriptorArray.length;
        while (n < n2) {
            PropertyDescriptor p = propertyDescriptorArray[n];
            if (p.getName().equals(propertyName)) {
                final Method m = p.getWriteMethod();
                if (m == null) break;
                return new AbstractEL(){

                    public boolean setValue(Object root, Object value) {
                        try {
                            ConvertContext context = new ConvertContext();
                            context.setPropertyName(propertyName);
                            context.setToType(m.getParameterTypes()[0]);
                            context.setValue(value);
                            ReflectionPropertyELFactory.this.fn.exec(context);
                            m.invoke(root, context.getValue());
                            return true;
                        }
                        catch (IllegalAccessException e) {
                            throw new IllegalStateException("error at " + clazz + " " + propertyName, e);
                        }
                        catch (InvocationTargetException e) {
                            throw new ELTargetRuntimeException(e);
                        }
                    }

                    public Object getValue(Object root, Class clazz2) {
                        return null;
                    }
                };
            }
            ++n;
        }
        throw new PropertyNotFoundException("property not found for " + clazz + ':' + propertyName);
    }

    public Fn<ConvertContext, Void, ? extends RuntimeException> getFn() {
        return this.fn;
    }

    public void setFn(Fn<ConvertContext, Void, ? extends RuntimeException> fn) {
        this.fn = fn;
    }
}

