/*
 * Decompiled with CFR 0.152.
 */
package woolpack.bool;

import java.util.Collection;
import java.util.regex.Pattern;
import woolpack.bool.BooleanState;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BoolUtils {
    public static final Fn<Object, Boolean, RuntimeException> NOT_THROWABLE = BoolUtils.not(BoolUtils.matchObject(Throwable.class));
    public static final Fn<Boolean, Boolean, RuntimeException> NOT = new Fn<Boolean, Boolean, RuntimeException>(){

        @Override
        public Boolean exec(Boolean c) {
            return c == false;
        }
    };
    public static final Fn<Object, Boolean, RuntimeException> NOT_EMPTY = new Fn<Object, Boolean, RuntimeException>(){

        @Override
        public Boolean exec(Object c) {
            if (!(c == null || c instanceof String && ((String)c).length() <= 0)) {
                return true;
            }
            return false;
        }
    };
    public static final Fn<Object, Boolean, RuntimeException> IS_NULL = new Fn<Object, Boolean, RuntimeException>(){

        @Override
        public Boolean exec(Object c) {
            if (c == null) {
                return true;
            }
            return false;
        }
    };
    public static final Fn<Object, Boolean, RuntimeException> TO_BOOLEAN = new Fn<Object, Boolean, RuntimeException>(){

        @Override
        public Boolean exec(Object c) {
            return c != null && !Boolean.FALSE.equals(c);
        }
    };
    public static final Fn<Object, Boolean, RuntimeException> TO_BOOLEAN_VIEW = new Fn<Object, Boolean, RuntimeException>(){

        @Override
        public Boolean exec(Object c) {
            if (c != null && !Boolean.FALSE.equals(c) && !"false".equalsIgnoreCase(c.toString())) {
                return true;
            }
            return false;
        }
    };
    public static final Fn<Object, BooleanState, RuntimeException> ANDAND = new Fn<Object, BooleanState, RuntimeException>(){

        @Override
        public BooleanState exec(Object c) {
            return new BooleanState(true){

                public void in(boolean flag) {
                    boolean newFlag = this.isCurrent() && flag;
                    this.setCurrent(newFlag);
                    this.setStopped(!newFlag);
                }
            };
        }
    };
    public static final Fn<Object, BooleanState, RuntimeException> AND = new Fn<Object, BooleanState, RuntimeException>(){

        @Override
        public BooleanState exec(Object c) {
            return new BooleanState(true){

                public void in(boolean flag) {
                    this.setCurrent(this.isCurrent() && flag);
                }
            };
        }
    };
    public static final Fn<Object, BooleanState, RuntimeException> EQEQ = new Fn<Object, BooleanState, RuntimeException>(){

        @Override
        public BooleanState exec(Object c) {
            return new BooleanState(true){
                private boolean trueFlag;
                private boolean falseFlag;
                {
                    this.trueFlag = true;
                    this.falseFlag = true;
                }

                public void in(boolean flag) {
                    this.trueFlag &= flag;
                    this.falseFlag &= !flag;
                    boolean newFlag = this.trueFlag || this.falseFlag;
                    this.setCurrent(newFlag);
                    this.setStopped(!newFlag);
                }
            };
        }
    };
    public static final Fn<Object, BooleanState, RuntimeException> EQ = new Fn<Object, BooleanState, RuntimeException>(){

        @Override
        public BooleanState exec(Object c) {
            return new BooleanState(true){
                private boolean trueFlag;
                private boolean falseFlag;
                {
                    this.trueFlag = true;
                    this.falseFlag = true;
                }

                public void in(boolean flag) {
                    this.trueFlag &= flag;
                    this.falseFlag &= !flag;
                    this.setCurrent(this.trueFlag || this.falseFlag);
                }
            };
        }
    };
    public static final Fn<Object, BooleanState, RuntimeException> OR = new Fn<Object, BooleanState, RuntimeException>(){

        @Override
        public BooleanState exec(Object c) {
            return new BooleanState(false){

                public void in(boolean flag) {
                    this.setCurrent(this.isCurrent() || flag);
                }
            };
        }
    };
    public static final Fn<Object, BooleanState, RuntimeException> OROR = new Fn<Object, BooleanState, RuntimeException>(){

        @Override
        public BooleanState exec(Object c) {
            return new BooleanState(false){

                public void in(boolean flag) {
                    boolean newFlag = this.isCurrent() || flag;
                    this.setCurrent(newFlag);
                    this.setStopped(newFlag);
                }
            };
        }
    };

    private BoolUtils() {
    }

    public static <C, E extends Exception> Fn<C, Boolean, E> boolSeq(final Fn<Object, ? extends BooleanState, ? extends RuntimeException> factory, final Iterable<? extends Fn<? super C, Boolean, ? extends E>> iterable) {
        return new Fn<C, Boolean, E>(){

            @Override
            public Boolean exec(C c) throws Exception {
                BooleanState state = (BooleanState)factory.exec(null);
                for (Fn e : iterable) {
                    state.in((Boolean)e.exec(c));
                    if (state.isStopped()) break;
                }
                return state.isCurrent();
            }
        };
    }

    public static <C extends Comparable<C>> Fn<C, Integer, RuntimeException> compare(final C value) {
        return new Fn<C, Integer, RuntimeException>(){

            @Override
            public Integer exec(C c) {
                return value.compareTo(c);
            }
        };
    }

    public static Fn<Collection<?>, Boolean, RuntimeException> containsAll(final Collection<?> collection) {
        return new Fn<Collection<?>, Boolean, RuntimeException>(){

            @Override
            public Boolean exec(Collection<?> c) {
                return collection.containsAll(c);
            }
        };
    }

    public static Fn<Object, Boolean, RuntimeException> contains(final Collection<?> collection) {
        return new Fn<Object, Boolean, RuntimeException>(){

            @Override
            public Boolean exec(Object c) {
                return collection.contains(c);
            }
        };
    }

    public static Fn<Object, Boolean, RuntimeException> checkEquals(final Object value) {
        return new Fn<Object, Boolean, RuntimeException>(){

            @Override
            public Boolean exec(Object c) {
                return value == null ? c == null : value.equals(c);
            }
        };
    }

    public static <C extends Comparable<C>> Fn<C, Boolean, RuntimeException> checkMax(final C value) {
        return new Fn<C, Boolean, RuntimeException>(){

            @Override
            public Boolean exec(C c) {
                if (value.compareTo(c) >= 0) {
                    return true;
                }
                return false;
            }
        };
    }

    public static Fn<String, Boolean, RuntimeException> checkMaxLength(final int value) {
        return new Fn<String, Boolean, RuntimeException>(){

            @Override
            public Boolean exec(String c) {
                if (c.length() <= value) {
                    return true;
                }
                return false;
            }
        };
    }

    public static <C extends Comparable<C>> Fn<C, Boolean, RuntimeException> checkMin(final C value) {
        return new Fn<C, Boolean, RuntimeException>(){

            @Override
            public Boolean exec(C c) {
                if (value.compareTo(c) <= 0) {
                    return true;
                }
                return false;
            }
        };
    }

    public static Fn<String, Boolean, RuntimeException> checkMinLength(final int value) {
        return new Fn<String, Boolean, RuntimeException>(){

            @Override
            public Boolean exec(String c) {
                if (c.length() >= value) {
                    return true;
                }
                return false;
            }
        };
    }

    public static <C, E extends Exception> Fn<C, Boolean, E> not(final Fn<? super C, Boolean, ? extends E> fn) {
        return new Fn<C, Boolean, E>(){

            @Override
            public Boolean exec(C c) throws Exception {
                return (Boolean)fn.exec(c) == false;
            }
        };
    }

    public static Fn<Object, Boolean, RuntimeException> matchObject(final Object value) {
        return new Fn<Object, Boolean, RuntimeException>(){

            @Override
            public Boolean exec(Object c) {
                if (value == null) {
                    if (c == null) {
                        return true;
                    }
                    return false;
                }
                if (value instanceof Class) {
                    return ((Class)value).isInstance(c);
                }
                return value.equals(c);
            }
        };
    }

    public static Fn<String, Boolean, RuntimeException> checkRegExp(final Pattern pattern) {
        return new Fn<String, Boolean, RuntimeException>(){

            @Override
            public Boolean exec(String c) {
                return pattern.matcher(c).matches();
            }
        };
    }

    public static <C, E extends Exception> Fn<C, Boolean, E> ifTrue(Fn<? super C, ?, ? extends E> ifFn, Fn<? super C, ? extends Boolean, ? extends E> trueFn) {
        return FnUtils.ifTrue(ifFn, trueFn, FnUtils.fixThrows(false));
    }

    public static <C, E extends Exception> Fn<C, Boolean, E> ifNot(Fn<? super C, ?, ? extends E> ifFn, Fn<? super C, ? extends Boolean, ? extends E> falseFn) {
        return FnUtils.ifTrue(ifFn, FnUtils.fixThrows(true), falseFn);
    }
}

