/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.samples.gcrud;

import java.util.List;

/**
 * 主キー制約と参照制約に対応するアンカーを保持する{@link SingleRowInfo}です。
 * @author nakamura
 *
 */
public class AnchorRowInfo extends SingleRowInfo{
	private SingleRowInfo primaryInfo;
	private List<SingleRowInfo> importedList;
	private List<SingleRowInfo> exportedList;
	
	public List<SingleRowInfo> getExportedList() {
		return exportedList;
	}
	public void setExportedList(final List<SingleRowInfo> exportedList) {
		this.exportedList = exportedList;
	}
	public List<SingleRowInfo> getImportedList() {
		return importedList;
	}
	public void setImportedList(final List<SingleRowInfo> importedList) {
		this.importedList = importedList;
	}
	public SingleRowInfo getPrimaryInfo() {
		return primaryInfo;
	}
	public void setPrimaryInfo(final SingleRowInfo primaryList) {
		this.primaryInfo = primaryList;
	}
}
