/*
 * Decompiled with CFR 0.152.
 */
package woolpack.xml;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import woolpack.fn.Fn;
import woolpack.xml.NodeContext;
import woolpack.xml.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentElementInserter<C extends NodeContext, E extends Exception>
implements Fn<C, Void, E> {
    private String elementName;
    private Fn<? super C, Void, ? extends E> fn;

    public ParentElementInserter(String elementName, Fn<? super C, Void, ? extends E> fn) {
        this.elementName = elementName;
        this.fn = fn;
    }

    @Override
    public Void exec(C context) throws E {
        Node base = context.getNode();
        Element element = XmlUtils.getDocumentNode(base).createElement(this.elementName);
        base.getParentNode().insertBefore(element, base);
        element.appendChild(base);
        try {
            context.setNode(element);
            this.fn.exec(context);
        }
        finally {
            context.setNode(base);
        }
        return null;
    }

    public Fn<? super C, Void, ? extends E> getFn() {
        return this.fn;
    }

    public void setFn(Fn<? super C, Void, ? extends E> fn) {
        this.fn = fn;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }
}

