/*
 * Decompiled with CFR 0.152.
 */
package woolpack.xml;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import woolpack.fn.Fn;
import woolpack.xml.NodeContext;
import woolpack.xml.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildElementInserter<C extends NodeContext, E extends Exception>
implements Fn<C, Void, E> {
    private String elementName;
    private Fn<? super C, Void, ? extends E> fn;

    public ChildElementInserter(String elementName, Fn<? super C, Void, ? extends E> fn) {
        this.elementName = elementName;
        this.fn = fn;
    }

    @Override
    public Void exec(C c) throws E {
        Node base = c.getNode();
        Element element = XmlUtils.getDocumentNode(base).createElement(this.elementName);
        Node child = null;
        while ((child = base.getFirstChild()) != null) {
            element.appendChild(child);
        }
        base.appendChild(element);
        try {
            c.setNode(element);
            this.fn.exec(c);
        }
        finally {
            c.setNode(base);
        }
        return null;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public Fn<? super C, Void, ? extends E> getFn() {
        return this.fn;
    }

    public void setFn(Fn<? super C, Void, ? extends E> fn) {
        this.fn = fn;
    }
}

