/*
 * Decompiled with CFR 0.152.
 */
package woolpack.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import woolpack.bool.BoolUtils;
import woolpack.bool.BooleanState;
import woolpack.fn.Fn;
import woolpack.utils.Utils;
import woolpack.validator.ConvertValidator;
import woolpack.validator.LocalIndexValidator;
import woolpack.validator.LocalKeyValidator;
import woolpack.validator.MapGetter;
import woolpack.validator.MessageValidator;
import woolpack.validator.NameBranch;
import woolpack.validator.NameBranchIfExists;
import woolpack.validator.ValidatorContext;
import woolpack.validator.ValueGetter;
import woolpack.validator.ValueLoopValidator;
import woolpack.validator.ValuesGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidatorUtils {
    public static final Fn<ValidatorContext, Object, RuntimeException> VALUE = new ValueGetter<RuntimeException>();
    public static final Fn<ValidatorContext, Map<String, List<Object>>, RuntimeException> MAP = new MapGetter<RuntimeException>();
    public static final Fn<ValidatorContext, List<Object>, RuntimeException> VALUES = new ValuesGetter<RuntimeException>();

    private ValidatorUtils() {
    }

    public static Map<String, List<Object>> convert(Map map) {
        HashMap<String, List<Object>> map1 = new HashMap<String, List<Object>>();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entryObject;
            Map.Entry entry = entryObject = iterator.next();
            Iterable<?> c = Utils.toIterable(entry.getValue());
            ArrayList list = new ArrayList();
            for (Object o : c) {
                list.add(o);
            }
            map1.put((String)entry.getKey(), list);
        }
        return map1;
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> branchByNameIfExists(Fn<Object, ? extends BooleanState, ? extends RuntimeException> operator, Map<String, ? extends Fn<? super ValidatorContext, Boolean, ? extends E>> map) {
        return new NameBranchIfExists(operator, map);
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> branchByNameIfExists(Map<String, ? extends Fn<? super ValidatorContext, Boolean, ? extends E>> map) {
        return new NameBranchIfExists(BoolUtils.AND, map);
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> branchByName(Fn<Object, ? extends BooleanState, ? extends RuntimeException> operator, Map<String, ? extends Fn<? super ValidatorContext, Boolean, ? extends E>> map) {
        return new NameBranch(operator, map);
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> branchByName(Map<String, ? extends Fn<? super ValidatorContext, Boolean, ? extends E>> map) {
        return new NameBranch(BoolUtils.AND, map);
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> convertValue(Fn<Object, ?, ? extends E> fn) {
        return new ConvertValidator<E>(fn);
    }

    public static Fn<ValidatorContext, Boolean, RuntimeException> message(String message) {
        return new MessageValidator<RuntimeException>(message);
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> localIndex(int tmpIndex, Fn<? super ValidatorContext, Boolean, ? extends E> fn) {
        return new LocalIndexValidator<E>(tmpIndex, fn);
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> localKey(String tmpKey, Fn<? super ValidatorContext, Boolean, ? extends E> fn) {
        return new LocalKeyValidator<E>(tmpKey, fn);
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> loopValue(Fn<Object, ? extends BooleanState, ? extends RuntimeException> operator, Fn<? super ValidatorContext, Boolean, ? extends E> fn) {
        return new ValueLoopValidator<E>(operator, fn);
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> loopValue(Fn<? super ValidatorContext, Boolean, ? extends E> fn) {
        return new ValueLoopValidator<E>(BoolUtils.AND, fn);
    }
}

