/*
 * Decompiled with CFR 0.152.
 */
package woolpack.utils;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyUtils {
    private PropertyUtils() {
    }

    public static Iterable<String> getGuessingIterable(final String s, final char separator) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private int i = 0;
                    private String tmpString;

                    @Override
                    public boolean hasNext() {
                        return this.i <= 7;
                    }

                    @Override
                    public String next() {
                        do {
                            switch (this.i) {
                                case 0: {
                                    this.tmpString = s;
                                    break;
                                }
                                case 1: {
                                    this.tmpString = PropertyUtils.toSQLName(s, separator);
                                    break;
                                }
                                case 2: {
                                    this.tmpString = this.tmpString.toLowerCase();
                                    break;
                                }
                                case 3: {
                                    this.tmpString = PropertyUtils.sqlWordHeadToUpper(this.tmpString);
                                    break;
                                }
                                case 4: {
                                    this.tmpString = PropertyUtils.toJavaName(s, separator);
                                    break;
                                }
                                case 5: {
                                    this.tmpString = String.valueOf(Character.toUpperCase(this.tmpString.charAt(0))) + this.tmpString.substring(1);
                                    break;
                                }
                                case 6: {
                                    this.tmpString = this.tmpString.toLowerCase();
                                    break;
                                }
                                case 7: {
                                    this.tmpString = this.tmpString.toUpperCase();
                                    break;
                                }
                                default: {
                                    this.tmpString = null;
                                    return null;
                                }
                            }
                            ++this.i;
                        } while (this.i != 1 && this.tmpString.equals(s));
                        return this.tmpString;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static String sqlWordHeadToUpper(String s) {
        StringBuilder sb = new StringBuilder(s);
        boolean flag = false;
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            if (flag || i == 0) {
                sb.setCharAt(i, Character.toUpperCase(c));
                flag = false;
            }
            if (c == '_') {
                flag = true;
            }
            ++i;
        }
        return sb.toString();
    }

    public static Iterable<String> getGuessingIterable(String s) {
        return PropertyUtils.getGuessingIterable(s, '_');
    }

    public static String toJavaName(String s) {
        return PropertyUtils.toJavaName(s, '_');
    }

    public static String toJavaName(String s, char separator) {
        if (s == null || s.indexOf(separator) < 0) {
            if (s != null && s.length() >= 1) {
                return String.valueOf(Character.toLowerCase(s.charAt(0))) + s.substring(1);
            }
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        boolean separateFlag = false;
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            if (c == separator) {
                separateFlag = true;
                sb.delete(i, i + 1);
                continue;
            }
            if (separateFlag) {
                c = Character.toUpperCase(c);
                separateFlag = false;
            } else {
                c = Character.toLowerCase(c);
            }
            sb.setCharAt(i, c);
            ++i;
        }
        return sb.toString();
    }

    public static String toSQLName(String s) {
        return PropertyUtils.toSQLName(s, '_');
    }

    public static String toSQLName(String s, char separator) {
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int length = s.length();
        boolean upper = false;
        int i = length - 1;
        while (i >= 0) {
            char c = s.charAt(i);
            if (Character.isLowerCase(c) && upper) {
                sb.insert(0, separator);
            }
            upper = Character.isUpperCase(c);
            sb.insert(0, Character.toUpperCase(c));
            --i;
        }
        return sb.toString();
    }
}

