/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.fn;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListResult<R>
implements Fn<Statement, List<R>, Exception> {
    private Fn<? super ResultSet, ? extends R, ? extends Exception> rowFn;
    private int max;
    private Fn<? super SQLException, ?, ? extends Exception> errorFn;

    public ListResult(Fn<? super ResultSet, ? extends R, ? extends Exception> fn, int max, Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        this.rowFn = fn;
        this.max = max;
        this.errorFn = errorFn;
    }

    @Override
    public List<R> exec(Statement c) throws Exception {
        SQLException e0;
        block10: {
            ArrayList<R> arrayList;
            e0 = null;
            ResultSet resultSet = c.getResultSet();
            try {
                ArrayList<R> list = new ArrayList<R>();
                int i = 0;
                while (resultSet.next()) {
                    if (++i > this.max) break;
                    list.add(this.rowFn.exec(resultSet));
                }
                arrayList = list;
            }
            catch (SQLException e1) {
                try {
                    try {
                        this.errorFn.exec(e1);
                        e0 = e1;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        resultSet.close();
                    }
                }
                catch (SQLException e12) {
                    this.errorFn.exec(e12);
                    if (e0 != null) break block10;
                    e0 = e12;
                }
            }
            resultSet.close();
            return arrayList;
        }
        if (e0 != null) {
            throw e0;
        }
        return null;
    }

    public Fn<? super ResultSet, ? extends R, ? extends Exception> getRowFn() {
        return this.rowFn;
    }

    public void setRowFn(Fn<? super ResultSet, ? extends R, ? extends Exception> fn) {
        this.rowFn = fn;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public Fn<? super SQLException, ?, ? extends Exception> getErrorFn() {
        return this.errorFn;
    }

    public void setErrorFn(Fn<? super SQLException, ?, ? extends Exception> errorFn) {
        this.errorFn = errorFn;
    }
}

