/*
 * Decompiled with CFR 0.152.
 */
package woolpack.html;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import woolpack.fn.Fn;
import woolpack.html.HtmlUtils;
import woolpack.xml.NodeContext;
import woolpack.xml.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeCell<E extends Exception>
implements Fn<NodeContext, Void, E> {
    private int colIndex;

    public MergeCell(int colIndex) {
        this.colIndex = colIndex;
    }

    @Override
    public Void exec(NodeContext c) {
        Element baseCell = null;
        NodeList trList = HtmlUtils.TR_LIST.exec(c.getNode());
        int i = 0;
        while (i < trList.getLength()) {
            NodeList tdList = HtmlUtils.TD_LIST.exec(trList.item(i));
            if (tdList.getLength() > this.colIndex) {
                if (baseCell == null) {
                    baseCell = (Element)tdList.item(this.colIndex);
                } else {
                    Element cell = (Element)tdList.item(this.colIndex);
                    if (XmlUtils.equalsNode(baseCell, cell)) {
                        String value = baseCell.getAttribute("rowspan");
                        if (value == null || value.length() == 0) {
                            value = "1";
                        }
                        baseCell.setAttribute("rowspan", String.valueOf(Integer.parseInt(value) + 1));
                        cell.getParentNode().removeChild(cell);
                    } else {
                        baseCell = cell;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public int getColIndex() {
        return this.colIndex;
    }

    public void setColIndex(int colIndex) {
        this.colIndex = colIndex;
    }
}

