/*
 * Decompiled with CFR 0.152.
 */
package woolpack.xml;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import woolpack.fn.Fn;
import woolpack.xml.NodeContext;
import woolpack.xml.NodeFindable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeFinder<C extends NodeContext>
implements Fn<C, Void> {
    private NodeFindable findable;
    private Fn<? super C, Void> firstFn;
    private Fn<? super C, Void> pluralFn;

    public NodeFinder(NodeFindable findable, Fn<? super C, Void> firstFn, Fn<? super C, Void> pluralFn) {
        this.findable = findable;
        this.firstFn = firstFn;
        this.pluralFn = pluralFn;
    }

    public NodeFinder(NodeFindable findable, Fn<? super C, Void> fn) {
        this(findable, fn, fn);
    }

    @Override
    public Void exec(C context) {
        Node base = context.getNode();
        NodeList nodeList = this.findable.evaluateList(base);
        Node[] beforeNodeList = new Node[nodeList.getLength()];
        int i = 0;
        while (i < nodeList.getLength()) {
            beforeNodeList[i] = nodeList.item(i);
            ++i;
        }
        try {
            i = 0;
            while (i < beforeNodeList.length) {
                context.setNode(beforeNodeList[i]);
                if (i == 0) {
                    this.firstFn.exec(context);
                } else {
                    this.pluralFn.exec(context);
                }
                ++i;
            }
        }
        finally {
            context.setNode(base);
        }
        return null;
    }

    public NodeFindable getFindable() {
        return this.findable;
    }

    public void setFindable(NodeFindable findable) {
        this.findable = findable;
    }

    public Fn<? super C, Void> getFirstFn() {
        return this.firstFn;
    }

    public void setFirstFn(Fn<? super C, Void> firstFn) {
        this.firstFn = firstFn;
    }

    public Fn<? super C, Void> getPluralFn() {
        return this.pluralFn;
    }

    public void setPluralFn(Fn<? super C, Void> pluralFn) {
        this.pluralFn = pluralFn;
    }
}

