/*
 * Decompiled with CFR 0.152.
 */
package woolpack.typeconvert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import woolpack.convert.ConvertUtils;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.fn.NullFn;
import woolpack.typeconvert.AbstractNumberConverter;
import woolpack.typeconvert.CollectionConverter;
import woolpack.typeconvert.ConvertContext;
import woolpack.typeconvert.Converter;
import woolpack.typeconvert.DelegationIfNecessityConverter;
import woolpack.typeconvert.PropertyNameGetter;
import woolpack.typeconvert.ToTypeConverter;
import woolpack.utils.BuildableArrayList;
import woolpack.utils.BuildableHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeConvertUtils {
    public static final Fn<ConvertContext, Class> GET_TO_TYPE = new Fn<ConvertContext, Class>(){

        @Override
        public Class exec(ConvertContext c) {
            return c.getToType();
        }
    };
    public static final Fn<ConvertContext, Class> GET_FROM_TYPE = new Fn<ConvertContext, Class>(){

        @Override
        public Class exec(ConvertContext c) {
            return c.getValue().getClass();
        }
    };
    private static final NumberFormat NUMBER_FORMAT = new DecimalFormat();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    public static final Fn<ConvertContext, Void> SIMPLE_CONVERTER = TypeConvertUtils.getSimpleConverter(NUMBER_FORMAT, DATE_FORMAT);
    public static final Fn<ConvertContext, Void> COLLECTION_CONVERTER = TypeConvertUtils.getCollectionConverter(NUMBER_FORMAT, DATE_FORMAT);
    public static final Fn<ConvertContext, String> GET_PROPERTY_NAME = new PropertyNameGetter();

    private TypeConvertUtils() {
    }

    private static Fn<ConvertContext, Void> getSimpleConverterPrivate(final NumberFormat numberFormat, DateFormat dateFormat) {
        return FnUtils.seq((Iterable)new BuildableArrayList<ToTypeConverter>().list(new ToTypeConverter(FnUtils.TO_WRAPPER)).list((ToTypeConverter)((Object)FnUtils.exec(FnUtils.join(GET_TO_TYPE, FnUtils.switching((Map)new BuildableHashMap<Class<String>, Fn>().map(String.class, FnUtils.exec(FnUtils.join(GET_FROM_TYPE, FnUtils.switching((Map)new BuildableHashMap<Class<java.util.Date>, Converter>().map(java.util.Date.class, new Converter(ConvertUtils.format(ConvertUtils.formatFactory(dateFormat)))).map(Number.class, new Converter(ConvertUtils.format(ConvertUtils.formatFactory(numberFormat)))).map(Byte.class).map(Short.class).map(Integer.class).map(Long.class).map(Float.class).map(Double.class).map(BigInteger.class).map(BigDecimal.class), new Converter(ConvertUtils.TO_STRING))))).map(Boolean.class, new Converter(new Fn<Object, Boolean>(){

            @Override
            public Boolean exec(Object c) {
                if (c != null && !"false".equals(c) && !Boolean.FALSE.equals(c)) {
                    return true;
                }
                return false;
            }
        })).map(Character.class, new Converter(new Fn<Object, Character>(){

            @Override
            public Character exec(Object c) {
                String s = c.toString();
                if (s.length() == 0) {
                    throw new IllegalArgumentException();
                }
                return Character.valueOf(s.charAt(0));
            }
        })).map(Date.class, new Converter(FnUtils.join(ConvertUtils.TO_STRING, ConvertUtils.parse(ConvertUtils.formatFactory(dateFormat)), ConvertUtils.TO_SQL_DATE))).map(java.util.Date.class, new Converter((Fn)FnUtils.join(ConvertUtils.TO_STRING, ConvertUtils.parse(ConvertUtils.formatFactory(dateFormat))))).map(Number.class, new Fn<ConvertContext, Void>(){

            @Override
            public Void exec(ConvertContext c) {
                Number number;
                if (Number.class.isAssignableFrom(c.getValue().getClass())) {
                    number = (Number)c.getValue();
                } else {
                    try {
                        number = numberFormat.parse(c.getValue().toString());
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                c.setValue(AbstractNumberConverter.convert(number, c.getToType()));
                return null;
            }
        }).map(Byte.class).map(Short.class).map(Integer.class).map(Long.class).map(Float.class).map(Double.class).map(BigInteger.class).map(BigDecimal.class), new NullFn()))))));
    }

    public static Fn<ConvertContext, Void> getSimpleConverter(NumberFormat numberFormat, DateFormat dateFormat) {
        return new DelegationIfNecessityConverter(TypeConvertUtils.getSimpleConverterPrivate(numberFormat, dateFormat));
    }

    public static Fn<ConvertContext, Void> getCollectionConverter(NumberFormat numberFormat, DateFormat dateFormat) {
        return new DelegationIfNecessityConverter(new CollectionConverter(TypeConvertUtils.getSimpleConverterPrivate(numberFormat, dateFormat)));
    }
}

