/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.tx;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxFn<C, R>
implements Fn<C, R> {
    private DataSource dataSource;
    private Fn<? super C, ? extends R> fn;

    public TxFn(DataSource dataSource, Fn<? super C, ? extends R> fn) {
        this.dataSource = dataSource;
        this.fn = fn;
    }

    @Override
    public R exec(C c) {
        Connection connection;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException sqlException) {
            throw new IllegalStateException(sqlException);
        }
        boolean errorFlag = false;
        try {
            R r = this.fn.exec(c);
            return r;
        }
        catch (RuntimeException e) {
            errorFlag = true;
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw e;
        }
        finally {
            block13: {
                try {
                    connection.close();
                }
                catch (SQLException sqlException) {
                    if (errorFlag) break block13;
                    throw new IllegalStateException(sqlException);
                }
            }
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Fn<? super C, ? extends R> getFn() {
        return this.fn;
    }

    public void setFn(Fn<? super C, ? extends R> fn) {
        this.fn = fn;
    }
}

