/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.fn;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListResult<R>
implements Fn<Statement, List<R>> {
    private Fn<? super ResultSet, ? extends R> rowFn;
    private int max;

    public ListResult(Fn<? super ResultSet, ? extends R> fn, int max) {
        this.rowFn = fn;
        this.max = max;
    }

    public ListResult(Fn<? super ResultSet, ? extends R> fn) {
        this(fn, Integer.MAX_VALUE);
    }

    @Override
    public List<R> exec(Statement c) {
        ArrayList<R> arrayList;
        ResultSet resultSet = c.getResultSet();
        try {
            ArrayList<R> list = new ArrayList<R>();
            int i = 0;
            while (resultSet.next()) {
                if (++i > this.max) break;
                list.add(this.rowFn.exec(resultSet));
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            try {
                resultSet.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
        resultSet.close();
        return arrayList;
    }

    public Fn<? super ResultSet, ? extends R> getRowFn() {
        return this.rowFn;
    }

    public void setRowFn(Fn<? super ResultSet, ? extends R> fn) {
        this.rowFn = fn;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }
}

