/*
 * Decompiled with CFR 0.152.
 */
package woolpack.factory;

import java.util.concurrent.ConcurrentMap;
import woolpack.el.EL;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SideEffectConcurrentMapCache<C, K>
implements Fn<C, Void> {
    private Fn<? super C, ? extends ConcurrentMap<? super K, Object>> mapGetter;
    private Fn<? super C, ? extends K> keyGetter;
    private Fn<? super C, ?> maker;
    private EL el;

    public SideEffectConcurrentMapCache(Fn<? super C, ? extends ConcurrentMap<? super K, Object>> mapGetter, Fn<? super C, ? extends K> keyGetter, Fn<? super C, ?> maker, EL el) {
        this.mapGetter = mapGetter;
        this.keyGetter = keyGetter;
        this.maker = maker;
        this.el = el;
    }

    @Override
    public Void exec(C c) {
        Object value;
        ConcurrentMap<K, Object> map = this.mapGetter.exec(c);
        K key = this.keyGetter.exec(c);
        while ((value = map.get(key)) == null) {
            this.maker.exec(c);
            map.putIfAbsent(key, this.el.getValue(c));
        }
        this.el.setValue(c, value);
        return null;
    }

    public EL getEl() {
        return this.el;
    }

    public void setEl(EL el) {
        this.el = el;
    }

    public Fn<? super C, ? extends K> getKeyGetter() {
        return this.keyGetter;
    }

    public void setKeyGetter(Fn<? super C, ? extends K> keyGetter) {
        this.keyGetter = keyGetter;
    }

    public Fn<? super C, ?> getMaker() {
        return this.maker;
    }

    public void setMaker(Fn<? super C, ?> maker) {
        this.maker = maker;
    }

    public Fn<? super C, ? extends ConcurrentMap<? super K, Object>> getMapGetter() {
        return this.mapGetter;
    }

    public void setMapGetter(Fn<? super C, ? extends ConcurrentMap<? super K, Object>> mapGetter) {
        this.mapGetter = mapGetter;
    }
}

