/*
 * Decompiled with CFR 0.152.
 */
package woolpack.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import woolpack.config.ConfigContext;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToLinkedHashMap
implements Fn<ConfigContext, Void> {
    private String newMapListPosition;
    private String valueSourcePosition;
    private String labelSourcePosition;
    private String separator;

    public ToLinkedHashMap(String newMapListPosition, String valueSourcePosition, String labelSourcePosition, String separator) {
        this.newMapListPosition = newMapListPosition;
        this.valueSourcePosition = valueSourcePosition;
        this.labelSourcePosition = labelSourcePosition;
        this.separator = separator;
    }

    @Override
    public Void exec(ConfigContext context) {
        String[] labelArray;
        String[] valueArray = ((String)context.getConfig().get(this.valueSourcePosition)).split(this.separator);
        if (valueArray.length != (labelArray = ((String)context.getConfig().get(this.labelSourcePosition)).split(this.separator)).length) {
            throw new ArrayIndexOutOfBoundsException("length unmatch : " + this.valueSourcePosition + " and " + this.labelSourcePosition);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < valueArray.length) {
            map.put(valueArray[i], labelArray[i]);
            ++i;
        }
        context.getConfig().put(this.newMapListPosition, Collections.unmodifiableMap(map));
        return null;
    }

    public String getLabelSourcePosition() {
        return this.labelSourcePosition;
    }

    public void setLabelSourcePosition(String labelSourcePosition) {
        this.labelSourcePosition = labelSourcePosition;
    }

    public String getNewMapListPosition() {
        return this.newMapListPosition;
    }

    public void setNewMapListPosition(String newMapListPosition) {
        this.newMapListPosition = newMapListPosition;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getValueSourcePosition() {
        return this.valueSourcePosition;
    }

    public void setValueSourcePosition(String valueSourcePosition) {
        this.valueSourcePosition = valueSourcePosition;
    }
}

