/*
 * Decompiled with CFR 0.152.
 */
package woolpack.acquirable;

import woolpack.acquirable.Acquirable;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcquireFn<C, R>
implements Fn<C, R> {
    private Fn<? super C, ? extends Acquirable> acquireGetter;
    private Fn<? super C, ? extends R> trueFn;
    private Fn<? super C, ? extends R> falseFn;

    public AcquireFn(Fn<? super C, ? extends Acquirable> acquireGetter, Fn<? super C, ? extends R> trueFn, Fn<? super C, ? extends R> falseFn) {
        this.acquireGetter = acquireGetter;
        this.trueFn = trueFn;
        this.falseFn = falseFn;
    }

    @Override
    public R exec(C c) {
        Acquirable acquirable = this.acquireGetter.exec(c);
        if (acquirable != null) {
            if (acquirable.acquire()) {
                try {
                    R r = this.trueFn.exec(c);
                    return r;
                }
                finally {
                    acquirable.release();
                }
            }
            return this.falseFn.exec(c);
        }
        return this.trueFn.exec(c);
    }

    public Fn<? super C, ? extends R> getFalseFn() {
        return this.falseFn;
    }

    public void setFalseFn(Fn<? super C, ? extends R> falseFn) {
        this.falseFn = falseFn;
    }

    public Fn<? super C, ? extends Acquirable> getAcquireGetter() {
        return this.acquireGetter;
    }

    public void setAcquireGetter(Fn<? super C, ? extends Acquirable> acquireGetter) {
        this.acquireGetter = acquireGetter;
    }

    public Fn<? super C, ? extends R> getTrueFn() {
        return this.trueFn;
    }

    public void setTrueFn(Fn<? super C, ? extends R> trueFn) {
        this.trueFn = trueFn;
    }
}

