/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.xml;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import woolpack.fn.Fn;

/**
 * DOM ノードを再帰的にループする抽象クラスです。
 * 各層をスナップショットとしてループします。
 * 
 * @author nakamura
 * 
 * @param <C>
 */
public abstract class AbstractNodeSeeker<C extends NodeContext> implements Fn<C, Void> {
	public Void exec(final C context) {
		final Node base = context.getNode();
		final Node[] beforeNodeList;
		{
			final NodeList nodeList = base.getChildNodes();
			beforeNodeList = new Node[nodeList.getLength()];
			for (int i = 0; i < nodeList.getLength(); i++) {
				beforeNodeList[i] = nodeList.item(i);
			}
		}

		try {
			for (int i = 0; i < beforeNodeList.length; i++) {
				context.setNode(beforeNodeList[i]);
				this.exec(context);
			}
		} finally {
			context.setNode(base);
		}
		return null;
	}
}
