/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.ee;

import java.util.Enumeration;
import java.util.Iterator;

import javax.servlet.ServletContext;

import woolpack.utils.AbstractKeyIteratorMap;

/**
 * {@link ServletContext}のアプリケーションスコープを{@link java.util.Map}に変換するアダプタです。
 * 本クラスは Servlet API のライブラリを使用します。
 * <br/>適用しているデザインパターン：Adapter。
 * 
 * @author nakamura
 * 
 */
public class ServletContextMap extends AbstractKeyIteratorMap<String, Object> {
	private final ServletContext child;

	public ServletContextMap(final ServletContext child) {
		super();
		this.child = child;
	}

	@Override
	protected Iterator<String> getKeyIterator() {
		final Enumeration e = child.getAttributeNames();
		return new Iterator<String>() {
			private String key;

			public void remove() {
				ServletContextMap.this.remove(key);
			}

			public boolean hasNext() {
				return e.hasMoreElements();
			}

			public String next() {
				key = (String) e.nextElement();
				return key;
			}
		};
	}

	@Override
	protected Object getValue(final Object key) {
		return child.getAttribute((String) key);
	}

	@Override
	public Object get(final Object key) {
		return getValue(key);
	}

	@Override
	public Object put(final String key, final Object value) {
		final Object before = getValue(key);
		child.setAttribute(key, value);
		return before;
	}

	@Override
	public Object remove(final Object key) {
		final Object before = getValue(key);
		child.removeAttribute((String) key);
		return before;
	}
}
