/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.convert;

import woolpack.fn.Fn;

/**
 * {@link Float}に変換する{@link Fn}です。
 * 一度値を double 型で取得して float 型に変換するため、
 * 丸め誤差が発生する可能性があります。
 * @author nakamura
 *
 */
public class ToFloatConverter implements Fn<Object, Float> {
	/**
	 * @throws ClassCastException 引数が{@link Number}でない場合。
	 */
	public Float exec(final Object c) {
		if (c instanceof Float) {
			return (Float) c;
		}
		return ((Number) c).floatValue();
	}
}
