/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.convert;

import java.util.Map;
import java.util.Set;

import woolpack.fn.Fn;

/**
 * {@link Map#keySet()}を返す{@link Fn}です。
 * @author nakamura
 *
 * @param <K>
 */
public class KeySetGetter<K> implements Fn<Map<K, ?>, Set<K>> {
	public Set<K> exec(final Map<K, ?> c) {
		return c.keySet();
	}
}
