/*
 * Decompiled with CFR 0.152.
 */
package woolpack.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;

public class RunnableGate {
    public static final long TIMEOUT = 500L;
    public static final String START = "start";
    public static final String END = "end";
    private final String startName;
    private final String endName;
    private final ExecutorService executor;
    private final long timeout;
    private final Map<Thread, Context> map;
    private final Object lock = new Object();
    private Context lastExecuted;

    public RunnableGate(String startName, String endName, ExecutorService executor, long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("timeout must be positive value.");
        }
        this.startName = startName;
        this.endName = endName;
        this.executor = executor;
        this.timeout = timeout;
        this.map = new HashMap<Thread, Context>();
    }

    public RunnableGate(ExecutorService executor) {
        this(START, END, executor, 500L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Context execute(Runnable runnable) {
        Object object = this.lock;
        synchronized (object) {
            long mark = System.currentTimeMillis();
            this.lastExecuted = null;
            this.executor.execute(this.getGate(this.startName, runnable, this.endName));
            try {
                while (true) {
                    if (this.lastExecuted != null) {
                        Context context = this.lastExecuted;
                        return context;
                    }
                    long t = this.timeout - (System.currentTimeMillis() - mark);
                    if (t <= 0L) {
                        throw new InterruptedException();
                    }
                    this.lock.wait(t);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
            finally {
                this.lastExecuted = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void put(String name) {
        Object object = this.lock;
        synchronized (object) {
            if (name.equals(this.startName)) {
                Context context = new Context(Thread.currentThread());
                this.map.put(Thread.currentThread(), context);
                this.lastExecuted = context;
            }
            this.map.get(Thread.currentThread()).add(name);
            if (name.equals(this.endName)) {
                this.map.remove(Thread.currentThread());
            }
            this.lock.notifyAll();
        }
    }

    public Runnable getGate(final String startName, final Runnable runnable, final String endName) {
        return new Runnable(){

            public void run() {
                RunnableGate.this.put(startName);
                try {
                    runnable.run();
                }
                finally {
                    RunnableGate.this.put(endName);
                }
            }
        };
    }

    public Runnable getGate(final String name) {
        return new Runnable(){

            public void run() {
                RunnableGate.this.put(name);
            }
        };
    }

    private Runnable getPause() {
        return new Runnable(){

            public void run() {
                Semaphore semaphore = new Semaphore(0, true);
                ((Context)RunnableGate.this.map.get(Thread.currentThread())).setSemaphore(semaphore);
                try {
                    try {
                        semaphore.acquire();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IllegalStateException(e);
                    }
                }
                finally {
                    ((Context)RunnableGate.this.map.get(Thread.currentThread())).setSemaphore(null);
                }
            }
        };
    }

    public Runnable getPause(String startName, String endName) {
        return this.getGate(startName, this.getPause(), endName);
    }

    static /* synthetic */ Object access$0(RunnableGate runnableGate) {
        return runnableGate.lock;
    }

    static /* synthetic */ long access$1(RunnableGate runnableGate) {
        return runnableGate.timeout;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Context {
        private final Thread thread;
        private final List<String> list;
        private final List<String> unmodifiableList;
        private Semaphore semaphore;

        Context(Thread thread) {
            this.thread = thread;
            this.list = new ArrayList<String>();
            this.unmodifiableList = Collections.unmodifiableList(this.list);
        }

        void setSemaphore(Semaphore semaphore) {
            this.semaphore = semaphore;
        }

        void add(String s) {
            this.list.add(s);
        }

        public void resume() {
            this.semaphore.release();
        }

        /*
         * Unable to fully structure code
         */
        public boolean waitFor(String name) {
            var2_2 = RunnableGate.access$0(RunnableGate.this);
            synchronized (var2_2) {
                mark = System.currentTimeMillis();
                while (true) lbl-1000:
                // 2 sources

                {
                    if (!this.list.contains(name)) ** break block8
                    return true;
                }
                {
                    block9: {
                        t = RunnableGate.access$1(RunnableGate.this) - (System.currentTimeMillis() - mark);
                        if (t > 0L) break block9;
                        return false;
                    }
                    try {
                        RunnableGate.access$0(RunnableGate.this).wait(t);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IllegalStateException(e);
                    }
                    ** while (true)
                }
            }
        }

        public boolean waitForStart() {
            return this.waitFor(RunnableGate.this.startName);
        }

        public boolean waitForEnd() {
            return this.waitFor(RunnableGate.this.endName);
        }

        public List<String> getList() {
            return this.unmodifiableList;
        }

        public List<String> getEndList() {
            if (!this.waitForEnd()) {
                throw new IllegalStateException("not finished.");
            }
            return this.unmodifiableList.subList(1, this.unmodifiableList.size() - 1);
        }

        public Thread getThread() {
            return this.thread;
        }
    }
}

