/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.tx;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import woolpack.sql.adapter.ConnectionAdapter;
import woolpack.sql.adapter.DataSourceAdapter;
import woolpack.sql.tx.TxContext;

public class TxBuilder {
    private DataSource dataSource;
    private ThreadLocal<TxContext> threadLocal;

    public TxBuilder(DataSource dataSource) {
        this.dataSource = dataSource;
        this.threadLocal = new ThreadLocal();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getTxDataSource() {
        return this.getTxDataSource(true);
    }

    public DataSource getTxDataSource(final boolean defaultCommitFlag) {
        return new DataSourceAdapter(this.dataSource){

            public Connection getConnection() {
                final TxContext context = new TxContext();
                TxBuilder.this.threadLocal.set(context);
                return new ConnectionAdapter(null){

                    public void commit() throws SQLException {
                        context.commit();
                    }

                    public void rollback() throws SQLException {
                        context.rollback();
                    }

                    public void close() throws SQLException {
                        Connection connection = context.getConnection();
                        if (connection == null) {
                            return;
                        }
                        try {
                            try {
                                try {
                                    context.closeAll();
                                }
                                finally {
                                    if (context.isRollback()) {
                                        connection.rollback();
                                    } else if (defaultCommitFlag || context.isCommit()) {
                                        connection.commit();
                                    }
                                }
                            }
                            finally {
                                connection.close();
                            }
                        }
                        finally {
                            TxBuilder.this.threadLocal.remove();
                        }
                    }
                };
            }
        };
    }

    public DataSource getTmpDataSource() {
        return this.getTmpDataSource(true);
    }

    public DataSource getTmpDataSource(final boolean refreshFlag) {
        return new DataSourceAdapter(this.dataSource){

            public Connection getConnection() throws SQLException {
                TxContext context = (TxContext)TxBuilder.this.threadLocal.get();
                if (context == null) {
                    throw new SQLException("transaction not start.");
                }
                if (context.isRollback()) {
                    throw new SQLException("already rollbacked.");
                }
                if (context.getConnection() == null) {
                    context.setConnection(super.getConnection());
                }
                if (refreshFlag) {
                    context.closeAll();
                }
                return context.newTmpConnection();
            }
        };
    }
}

