/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.test;

import java.util.Collection;

/**
 * テスト用のBeanです。
 * @author nakamura
 *
 */
public class TestBean {
	private int count = 0;
	private int myInt;
	private int[] myIntArray;
	private Collection myCollection;

	public void executeVoid() {
	}

	public int executeInt() {
		count++;
		return count;
	}

	public void executeException() {
		throw new IndexOutOfBoundsException();
	}

	public int getMyInt() {
		return myInt;
	}

	public void setMyInt(final int myInt) {
		this.myInt = myInt;
	}

	public int[] getMyIntArray() {
		return (int[]) myIntArray.clone();
	}

	public void setMyIntArray(final int[] myIntArray) {
		this.myIntArray = (int[]) myIntArray.clone();
	}

	public Collection getMyCollection() {
		return myCollection;
	}

	public void setMyCollection(final Collection myCollection) {
		this.myCollection = myCollection;
	}
}
