/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;

import woolpack.test.TestBean;

public class PropertyELTest extends TestCase {
	public void testNormalBean() {
		final TestBean bean = new TestBean();

		assertEquals(Integer.valueOf(0), new PropertyEL("myInt",
				ELUtils.PROPERTY_EL_FACTORY).getValue(bean));
		assertEquals("0", new PropertyEL("myInt",
				ELUtils.PROPERTY_EL_FACTORY).getValue(bean, String.class));
		new PropertyEL("myInt", ELUtils.PROPERTY_EL_FACTORY).setValue(bean,
				Integer.valueOf(2));
		new PropertyEL("myInt", ELUtils.PROPERTY_EL_FACTORY).setValue(bean,
				Integer.valueOf(1));
		assertEquals(Integer.valueOf(1), new PropertyEL("myInt",
				ELUtils.PROPERTY_EL_FACTORY).getValue(bean));

		try {
			new PropertyEL("yourInt", ELUtils.PROPERTY_EL_FACTORY)
					.getValue(bean);
			fail();
		} catch (final IllegalArgumentException expected) {
			assertEquals(
					"property not found:class woolpack.test.TestBean:yourInt",
					expected.getMessage());
		}
		try {
			new PropertyEL("yourInt", ELUtils.PROPERTY_EL_FACTORY)
					.getValue(bean, String.class);
			fail();
		} catch (final IllegalArgumentException expected) {
			assertEquals(
					"property not found:class woolpack.test.TestBean:yourInt",
					expected.getMessage());
		}
		try {
			new PropertyEL("yourInt", ELUtils.PROPERTY_EL_FACTORY)
					.setValue(bean, Integer.valueOf(2));
			fail();
		} catch (final IllegalArgumentException expected) {
			assertEquals(
					"property not found:class woolpack.test.TestBean:yourInt",
					expected.getMessage());
		}
	}

	public void testNormalMap() {
		final Map<String, Object> map = new HashMap<String, Object>();
		map.put("param0", Integer.valueOf(3));
		assertEquals(Integer.valueOf(3), new PropertyEL("param0",
				ELUtils.PROPERTY_EL_FACTORY).getValue(map));
		assertEquals("3", new PropertyEL("param0",
				ELUtils.PROPERTY_EL_FACTORY).getValue(map, String.class));

		new PropertyEL("param1", ELUtils.PROPERTY_EL_FACTORY).setValue(map,
				"value2");
		new PropertyEL("param1", ELUtils.PROPERTY_EL_FACTORY).setValue(map,
				"value1");
		assertEquals("value1", new PropertyEL("param1",
				ELUtils.PROPERTY_EL_FACTORY).getValue(map));

		assertNull(new PropertyEL("param2", ELUtils.PROPERTY_EL_FACTORY)
				.getValue(map));

		new PropertyEL("param3", ELUtils.PROPERTY_EL_FACTORY).setValue(map,
				null);
		assertNull(new PropertyEL("param3", ELUtils.PROPERTY_EL_FACTORY)
				.getValue(map));
	}
}
