/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import woolpack.el.ELUtils;
import woolpack.el.GettingEL;
import woolpack.el.PathEL;

import junit.framework.TestCase;

public class ActionDefTest extends TestCase {
	public void testAccessor0() {
		final GettingEL el = new PathEL("a");
		final List<ForwardDef> iterable = new ArrayList<ForwardDef>();
		final ActionDef def = new ActionDef(el, iterable);
		assertEquals(ELUtils.NULL, def.getComponentEL());
		assertEquals(el, def.getMethodEL());
		assertEquals(iterable, def.getForwardDefIterable());
	}

	public void testAccessor1() {
		final GettingEL el = new PathEL("a");
		final ForwardDef[] array = {new ForwardDef("id0")};
		final ActionDef def = new ActionDef(el, array);
		assertEquals(ELUtils.NULL, def.getComponentEL());
		assertEquals(el, def.getMethodEL());
		assertEquals(Arrays.asList(array), def.getForwardDefIterable());
	}
}
